/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.energy.tile;

import com.valkyrieofnight.vlib.core.obj.container.IOHandler;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IConfigurableIORate;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.integration.forge.energy.IConfigurableIORateForgeEnergy;
import com.valkyrieofnight.vlib.integration.forge.energy.util.ForgeEnergyUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyIOHandler
extends IOHandler {
    private final IEnergyStorage internalEnergyStorage;

    public EnergyIOHandler(IInventory ioSlots, EnumIO ioMode, IEnergyStorage energyStorage) {
        super(ioSlots, ioMode);
        this.internalEnergyStorage = energyStorage;
    }

    public EnergyIOHandler(IInventory ioSlots, EnumIO ioMode, IEnergyStorage energyStorage, Action setChangedMethod) {
        super(ioSlots, ioMode, setChangedMethod);
        this.internalEnergyStorage = energyStorage;
    }

    @Override
    public boolean isInternalStorageEmpty() {
        return this.internalEnergyStorage.getEnergyStored() == 0;
    }

    @Override
    public boolean isInternalStorageFull() {
        return this.internalEnergyStorage.getEnergyStored() == this.internalEnergyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean isItemStorageEmpty(ItemStack itemStack) {
        IEnergyStorage energyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored() == 0;
        }
        return true;
    }

    @Override
    public boolean isItemStorageFull(ItemStack itemStack) {
        IEnergyStorage energyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored() == energyStorage.getMaxEnergyStored();
        }
        return false;
    }

    @Override
    public int getInternalStorageStoredAmount() {
        return this.internalEnergyStorage.getEnergyStored();
    }

    @Override
    public int getItemStorageStoredAmount(ItemStack itemStack) {
        IEnergyStorage energyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getInternalStorageInputRate() {
        if (this.internalEnergyStorage instanceof IConfigurableIORateForgeEnergy) {
            return ((IConfigurableIORate)this.internalEnergyStorage).getInputRate();
        }
        return this.internalEnergyStorage.receiveEnergy(Integer.MAX_VALUE, true);
    }

    @Override
    public int getInternalStorageOutputRate() {
        if (this.internalEnergyStorage instanceof IConfigurableIORateForgeEnergy) {
            return ((IConfigurableIORate)this.internalEnergyStorage).getOutputRate();
        }
        return this.internalEnergyStorage.extractEnergy(Integer.MAX_VALUE, true);
    }

    @Override
    public int getItemStorageInputRate(ItemStack itemStack) {
        IEnergyStorage energyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (energyStorage instanceof IConfigurableIORateForgeEnergy) {
            return ((IConfigurableIORate)energyStorage).getInputRate();
        }
        if (energyStorage != null) {
            return energyStorage.receiveEnergy(Integer.MAX_VALUE, true);
        }
        return 0;
    }

    @Override
    public int getItemStorageOutputRate(ItemStack itemStack) {
        IEnergyStorage energyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (energyStorage instanceof IConfigurableIORateForgeEnergy) {
            return ((IConfigurableIORate)energyStorage).getOutputRate();
        }
        if (energyStorage != null) {
            return energyStorage.extractEnergy(Integer.MAX_VALUE, true);
        }
        return 0;
    }

    @Override
    public int transferFromItemStorageToInternalStorage(ItemStack itemStack, int maxAmount) {
        IEnergyStorage itemEnergyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (itemEnergyStorage != null) {
            int inserted;
            int extracted = itemEnergyStorage.extractEnergy(maxAmount, false);
            if (extracted != (inserted = this.internalEnergyStorage.receiveEnergy(extracted, false))) {
                itemEnergyStorage.receiveEnergy(extracted - inserted, false);
            }
            return inserted;
        }
        return 0;
    }

    @Override
    public int transferFromInternalStorageToItemStorage(ItemStack itemStack, int maxAmount) {
        IEnergyStorage itemEnergyStorage = ForgeEnergyUtil.getEnergyStorageFromItemStack(itemStack);
        if (itemEnergyStorage != null) {
            int inserted;
            int extracted = this.internalEnergyStorage.extractEnergy(maxAmount, false);
            if (extracted != (inserted = itemEnergyStorage.receiveEnergy(extracted, false))) {
                this.internalEnergyStorage.receiveEnergy(extracted - inserted, false);
            }
            return inserted;
        }
        return 0;
    }
}

