/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.obj;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.CapabilityProvider;

public class ItemStackUtils {
    public static ItemStack getItemFromString(String str) {
        return null;
    }

    public static ItemStack getItemFromID(VLID id) {
        return null;
    }

    public static CompoundNBT getOrCreateDisplayTag(@NotNull ItemStack stack) {
        if (!stack.func_196082_o().func_150297_b("display", 10)) {
            stack.func_196082_o().func_218657_a("display", (INBT)new CompoundNBT());
        }
        return stack.func_196082_o().func_74775_l("display");
    }

    public static void setDisplayTag(@NotNull ItemStack stack, CompoundNBT tag) {
        stack.func_77983_a("display", (INBT)tag);
    }

    public static ListNBT getOrCreateLoreTag(@NotNull ItemStack stack) {
        CompoundNBT dt = ItemStackUtils.getOrCreateDisplayTag(stack);
        if (!dt.func_74764_b("Lore")) {
            dt.func_218657_a("Lore", (INBT)new ListNBT());
        }
        return ItemStackUtils.getOrCreateDisplayTag(stack).func_150295_c("Lore", 8);
    }

    public static void setLoreTag(@NotNull ItemStack stack, ListNBT list) {
        CompoundNBT dt = ItemStackUtils.getOrCreateDisplayTag(stack);
        dt.func_218657_a("Lore", (INBT)list);
        ItemStackUtils.setDisplayTag(stack, dt);
    }

    public static void addLore(@NotNull ItemStack stack, ITextComponent lore) {
        ListNBT oldLoreTag = ItemStackUtils.getOrCreateLoreTag(stack);
        oldLoreTag.add(oldLoreTag.size(), (INBT)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)lore)));
        ItemStackUtils.setLoreTag(stack, oldLoreTag);
    }

    public static boolean canItemStacksStack(@NotNull ItemStack a, @NotNull ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    @NotNull
    public static ItemStack copyWithSize(@NotNull ItemStack stack, int size) {
        if (size == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(size);
        return copy;
    }

    public static CompoundNBT saveAllItems(CompoundNBT tag, NonNullList<ItemStack> list) {
        return ItemStackUtils.saveAllItems(tag, list, true);
    }

    public static CompoundNBT saveAllItems(CompoundNBT tag, NonNullList<ItemStack> list, boolean saveEmpty) {
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = (ItemStack)list.get(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74768_a("slot", i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty() || saveEmpty) {
            tag.func_218657_a("items", (INBT)listnbt);
        }
        return tag;
    }

    public static void loadAllItems(CompoundNBT tag, NonNullList<ItemStack> list) {
        ListNBT listnbt = tag.func_150295_c("items", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74762_e("slot") & 0xFF;
            if (j < 0 || j >= list.size()) continue;
            list.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    public static boolean isEmpty(NonNullList<ItemStack> inv) {
        for (ItemStack itemstack : inv) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack split(ItemStack sourceStack, int amount) {
        int i = Math.min(amount, sourceStack.func_190916_E());
        ItemStack itemstack = sourceStack.func_77946_l();
        if (i == 0) {
            itemstack = ItemStack.field_190927_a;
        } else {
            itemstack.func_190920_e(i);
        }
        sourceStack.func_190918_g(i);
        return itemstack;
    }

    public static ItemStack getAndSplit(List<ItemStack> contents, int index, int count) {
        return index >= 0 && index < contents.size() && !contents.get(index).func_190926_b() && count > 0 ? ItemStackUtils.split(contents.get(index), count) : ItemStack.field_190927_a;
    }

    public static ItemStack getAndRemove(List<ItemStack> contents, int index) {
        return index >= 0 && index < contents.size() ? contents.set(index, ItemStack.field_190927_a) : ItemStack.field_190927_a;
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

