/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.obj;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidUtils {
    public static boolean isBucket(ItemStack stack) {
        Item i = stack.func_77973_b();
        return i instanceof BucketItem;
    }

    @NotNull
    public static Collection<Fluid> getFluidsFromItem(@NotNull ItemStack stack) {
        if (stack.func_77973_b() instanceof BucketItem) {
            return Collections.singletonList(((BucketItem)stack.func_77973_b()).getFluid());
        }
        LazyOptional ifh = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (ifh.isPresent()) {
            ArrayList fluids = Lists.newArrayList();
            IFluidHandlerItem fhi = (IFluidHandlerItem)ifh.resolve().get();
            for (int i = 0; i < fhi.getTanks(); ++i) {
                FluidStack fs = fhi.getFluidInTank(i);
                if (fs == FluidStack.EMPTY) continue;
                fluids.add(fs.getFluid());
            }
            return fluids;
        }
        return Collections.EMPTY_LIST;
    }
}

