/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.color;

import com.valkyrieofnight.vlib.core.util.color.ColorUtil;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import net.minecraft.util.text.Color;

public final class Color4 {
    public static final Color4 RED = new Color4(1.0f, 0.0f, 0.0f);
    public static final Color4 ROSE = new Color4(1.0f, 0.0f, 0.5f);
    public static final Color4 MAGENTA = new Color4(1.0f, 0.0f, 1.0f);
    public static final Color4 VIOLET = new Color4(0.5f, 0.0f, 1.0f);
    public static final Color4 BLUE = new Color4(0.0f, 0.0f, 1.0f);
    public static final Color4 AZURE = new Color4(0.0f, 0.5f, 1.0f);
    public static final Color4 CYAN = new Color4(0.0f, 1.0f, 1.0f);
    public static final Color4 SPRING_GREEN = new Color4(0.0f, 1.0f, 0.5f);
    public static final Color4 GREEN = new Color4(0.0f, 1.0f, 0.0f);
    public static final Color4 CHARTREUSE = new Color4(0.5f, 1.0f, 0.0f);
    public static final Color4 YELLOW = new Color4(1.0f, 1.0f, 0.0f);
    public static final Color4 ORANGE = new Color4(1.0f, 0.5f, 0.0f);
    public static final Color4 DARK_RED = new Color4(0.55f, 0.0f, 0.0f);
    public static final Color4 DARK_GREEN = new Color4(0.0f, 0.55f, 0.0f);
    public static final Color4 DARK_BLUE = new Color4(0.0f, 0.0f, 0.55f);
    public static final Color4 BLACK = new Color4(0.0f, 0.0f, 0.0f);
    public static final Color4 SILVER = new Color4(0.75f, 0.75f, 0.75f);
    public static final Color4 GRAY = new Color4(0.5f, 0.5f, 0.5f);
    public static final Color4 WHITE = new Color4(1.0f, 1.0f, 1.0f);
    protected final float r;
    protected final float g;
    protected final float b;
    protected final float a;
    protected final int ri;
    protected final int gi;
    protected final int bi;
    protected final int ai;

    public Color4() {
        this(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Color4(int rgba) {
        this(ColorUtil.getR(rgba), ColorUtil.getG(rgba), ColorUtil.getB(rgba), ColorUtil.getA(rgba));
    }

    public Color4(int rgb, int alpha) {
        this(ColorUtil.getR(rgb), ColorUtil.getG(rgb), ColorUtil.getB(rgb), alpha);
    }

    public static int calcMCColor(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int calcMCColor(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public Color4(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color4(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color4(float r, float g, float b, float a) {
        this.r = MathUtil.clamp(r, 0.0f, 1.0f);
        this.g = MathUtil.clamp(g, 0.0f, 1.0f);
        this.b = MathUtil.clamp(b, 0.0f, 1.0f);
        this.a = MathUtil.clamp(a, 0.0f, 1.0f);
        this.ri = (int)(this.r * 255.0f);
        this.gi = (int)(this.g * 255.0f);
        this.bi = (int)(this.b * 255.0f);
        this.ai = (int)(this.a * 255.0f);
    }

    public Color4(int r, int g, int b, int a) {
        this.ri = MathUtil.clamp(r, 0, 255);
        this.gi = MathUtil.clamp(g, 0, 255);
        this.bi = MathUtil.clamp(b, 0, 255);
        this.ai = MathUtil.clamp(a, 0, 255);
        this.r = (float)this.ri / 255.0f;
        this.g = (float)this.gi / 255.0f;
        this.b = (float)this.bi / 255.0f;
        this.a = (float)this.ai / 255.0f;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    public int getRi() {
        return this.ri;
    }

    public int getGi() {
        return this.gi;
    }

    public int getBi() {
        return this.bi;
    }

    public int getAi() {
        return this.ai;
    }

    public Color getMCColor() {
        return Color.func_240743_a_((int)this.getRGBA());
    }

    public int getRGBA() {
        return ColorUtil.calcRGBA(this.ri, this.gi, this.bi, this.ai);
    }

    public static Color4 from(int r, int g, int b) {
        return new Color4(ColorUtil.getRF(r), ColorUtil.getGF(g), ColorUtil.getBF(b));
    }

    public static Color4 from(int r, int g, int b, int a) {
        return new Color4(ColorUtil.getRF(r), ColorUtil.getGF(g), ColorUtil.getBF(b), ColorUtil.getAF(a));
    }

    public static Color4 from(Color color) {
        return new Color4(color.func_240742_a_(), 255);
    }
}

