/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class WorldUtils {
    private static Direction[] ALL_DIRECTIONS = Direction.values();

    public static float getSunBrightness(World world, float partialTicks) {
        float celestialAngleRadians = world.func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplier = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathUtil.clamp(multiplier * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement)), 0.0f, 1.0f);
    }

    public static float getMoonBrightness(World world) {
        return world.func_242413_ae();
    }

    public static BlockPos searchViewable(@NotNull IWorldReader world, @NotNull BlockPos startPos, @NotNull Direction direction, int maxRange) {
        BlockPos last = startPos;
        for (int r = 0; r < maxRange; ++r) {
            BlockPos p = startPos.func_177972_a(direction);
            BlockState bs = world.func_180495_p(p);
            if (bs.isAir((IBlockReader)world, p)) continue;
            if (bs.func_200016_a((IBlockReader)world, p) > 15 && !bs.func_185904_a().func_76224_d()) {
                return last;
            }
            last = p;
        }
        return last;
    }

    @Nullable
    public static BlockState getStateForPlacement(ItemStack stack, BlockPos pos, PlayerEntity player, Hand hand) {
        BlockState s = Block.func_149634_a((Item)stack.func_77973_b()).func_196258_a(new BlockItemUseContext(new ItemUseContext(player, hand, new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, pos, false))));
        return s;
    }

    public static BlockState updateBlockPostPlacement(IWorld world, BlockState state, BlockPos pos) {
        return WorldUtils.updateBlockPostPlacement(world, state, pos, ALL_DIRECTIONS);
    }

    public static BlockState updateBlockPostPlacement(IWorld world, BlockState state, BlockPos pos, Direction ... directions) {
        BlockState ret = state;
        for (Direction from : directions) {
            ret = ret.func_196956_a(from, world.func_180495_p(pos.func_177972_a(from)), world, pos, pos.func_177972_a(from));
        }
        return ret;
    }

    public static void harvestBlock(World w, BlockPos pos, BlockState state, PlayerEntity playerEntity, boolean dropBlock) {
        state.func_177230_c().func_176208_a(w, pos, state, playerEntity);
        w.func_175655_b(pos, dropBlock);
    }

    public static void harvestBlockAndPickup(World w, BlockPos pos, BlockState state, PlayerEntity playerEntity) {
        new BlockPos(Vector3d.func_237489_a_((Vector3i)pos));
        LootContext.Builder lc = new LootContext.Builder((ServerWorld)w).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)WorldUtils.getToolOfType(state.getHarvestTool())).func_216021_b(LootParameters.field_216288_h, (Object)w.func_175625_s(pos));
        state.func_177230_c().func_176208_a(w, pos, state, playerEntity);
        List stackList = state.func_215693_a(lc);
        stackList.forEach(is -> {
            if (!playerEntity.field_71071_by.func_70441_a(is)) {
                ItemEntity ie = playerEntity.field_70170_p.func_230315_m_() == w.func_230315_m_() ? new ItemEntity(w, playerEntity.func_213303_ch().field_72450_a, playerEntity.func_213303_ch().field_72448_b, playerEntity.func_213303_ch().field_72449_c, is) : new ItemEntity(w, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), is);
                ie.func_230279_az_();
                w.func_217376_c((Entity)ie);
            }
        });
        w.func_175655_b(pos, false);
    }

    private static ItemStack getToolOfType(ToolType toolType) {
        if (toolType == ToolType.AXE) {
            return new ItemStack((IItemProvider)Items.field_234757_kL_);
        }
        if (toolType == ToolType.HOE) {
            return new ItemStack((IItemProvider)Items.field_234758_kU_);
        }
        if (toolType == ToolType.PICKAXE) {
            return new ItemStack((IItemProvider)Items.field_234756_kK_);
        }
        if (toolType == ToolType.SHOVEL) {
            return new ItemStack((IItemProvider)Items.field_234755_kJ_);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean placeBlock(IWorld world, BlockPos pos, BlockState state) {
        if (world.func_180501_a(pos, state, 3)) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                te.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public static boolean placeBlock(World world, BlockPos pos, ItemStack stack, boolean loadNBT) {
        Block blk = Block.func_149634_a((Item)stack.func_77973_b());
        if (blk == Blocks.field_150350_a || blk == Blocks.field_201941_jj) {
            return false;
        }
        BlockState bs = blk.func_176223_P();
        if (WorldUtils.placeBlock(world, pos, bs)) {
            BlockState bs2 = world.func_180495_p(pos);
            Block blk2 = bs2.func_177230_c();
            if (blk2 == blk) {
                bs2 = WorldUtils.updateBlockStateFromTag(pos, world, stack, bs2);
                BlockItem.func_179224_a((World)world, null, (BlockPos)pos, (ItemStack)stack);
                blk2.func_180633_a(world, pos, bs2, null, stack);
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    te.func_145829_t();
                    te.func_70296_d();
                    te.func_145836_u();
                    world.func_175646_b(pos, te);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean placeBlock(World world, BlockPos pos, BlockState state) {
        return world.func_180501_a(pos, state, 3);
    }

    private static BlockState updateBlockStateFromTag(BlockPos pos, World world, ItemStack stack, BlockState state) {
        BlockState blockstate = state;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT nbt = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = state.func_177230_c().func_176194_O();
            for (String s : nbt.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = nbt.func_74781_a(s).func_150285_a_();
                blockstate = WorldUtils.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != state) {
            world.func_180501_a(pos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> prop, String val) {
        return prop.func_185929_b(val).map(ent -> (BlockState)state.func_206870_a(prop, ent)).orElse(state);
    }
}

