/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.DefaultTheme;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ThemeRegistryClient
extends ThemeRegistry {
    private static final ThemeRegistryClient INST = new ThemeRegistryClient();
    private volatile ConcurrentMap<ThemeID, Theme> clientThemes = Maps.newConcurrentMap();
    private static final String THEME_DIR = "valkyrielib:textures/gui/themes/default/";
    public static final VLID VANILLA_BACKGROUNDS = new VLID("valkyrielib:textures/gui/themes/default/vanilla_gsb_backgrounds.png");
    public static final VLID VANILLA_BUTTONS = new VLID("valkyrielib:textures/gui/themes/default/vanilla_gsb_buttons.png");
    public static final VLID VANILLA_OTHER = new VLID("valkyrielib:textures/gui/themes/default/vanilla_gsb_other.png");
    public static final VLID VANILLA_TEX_OTHER = new VLID("valkyrielib:textures/gui/themes/default/vanilla_tex_other.png");
    public static final VLID VANILLA_SYMBOLS = new VLID("valkyrielib:textures/gui/themes/default/vanilla_tex_symbols.png");
    public static final VLID VLIB_GSB_BACKGROUNDS = new VLID("valkyrielib:textures/gui/themes/default/vlib_gsb_backgrounds.png");
    public static final VLID VLIB_LOGOS_CURSEFORGE = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_curseforge.png");
    public static final VLID VLIB_LOGOS_DISCORD = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_discord.png");
    public static final VLID VLIB_LOGOS_GITHUB = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_github.png");
    public static final VLID VLIB_LOGOS_PATREON = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_patreon.png");
    public static final VLID VLIB_LOGOS_TWITCH = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_twitch.png");
    public static final VLID VLIB_LOGOS_TWITTER = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_twitter.png");
    public static final VLID VLIB_LOGOS_YOUTUBE = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_logos_youtube.png");
    public static final VLID VLIB_SYMBOLS_FLAT_14 = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_symbols_flat_14x14.png");
    public static final VLID VLIB_SYMBOLS_FLAT_48 = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_symbols_flat_48x48.png");
    public static final VLID VLIB_PROGRESS_BARS = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_progress_bars.png");
    public static final VLID VLIB_BAR_OVERLAYS = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_bar_overlays.png");
    public static final VLID VLIB_TEX_OTHER = new VLID("valkyrielib:textures/gui/themes/default/vlib_tex_other.png");
    private static StandardThemeAssets STA;

    public static ThemeRegistryClient getInstance() {
        return INST;
    }

    private ThemeRegistryClient() {
        this.getOrCreate(DEFAULT, () -> new DefaultTheme(DEFAULT, this));
    }

    public final DefaultTheme getDefault() {
        return (DefaultTheme)this.getOrCreate(DEFAULT, () -> new DefaultTheme(DEFAULT, this));
    }

    public final Theme getTheme(ThemeID id) {
        return this.getOrCreate(id);
    }

    @Override
    protected void onThemeCreated(ThemeID theme) {
        this.getOrCreate(theme);
    }

    private final Theme getOrCreate(ThemeID theme) {
        if (theme == null || DEFAULT.equals(theme)) {
            return this.getDefault();
        }
        return this.clientThemes.computeIfAbsent(theme, v -> new Theme(theme, this));
    }

    private final Theme getOrCreate(ThemeID themeID, Provider<Theme> theme) {
        if (theme == null || DEFAULT.equals(theme)) {
            return this.getDefault();
        }
        return this.clientThemes.computeIfAbsent(themeID, v -> (Theme)theme.request());
    }

    public synchronized void registerTexture(ThemeID themeID, AssetID id, GuiTexture texture) {
        this.getOrCreate((ThemeID)themeID).textureMap.computeIfAbsent(id, v -> texture);
    }

    public synchronized void registerColor(ThemeID themeID, AssetID id, Color4 color4) {
        this.getOrCreate((ThemeID)themeID).colorMap.computeIfAbsent(id, v -> color4);
    }

    public synchronized void registerSizableBox(ThemeID themeID, AssetID id, GuiSizableBox box) {
        this.getOrCreate((ThemeID)themeID).boxMap.computeIfAbsent(id, v -> box);
    }

    public static void registerDefaultAssets(ThemeRegistryClient container) {
        StandardThemeAssets.addGSBBackgrounds(DEFAULT, VANILLA_BACKGROUNDS, container, 256, 256);
        StandardThemeAssets.addGSBButtons(DEFAULT, VANILLA_BUTTONS, container, 256, 256);
        StandardThemeAssets.addGSBOther(DEFAULT, VANILLA_OTHER, container, 256, 256);
        StandardThemeAssets.addGeneralElements(DEFAULT, VANILLA_TEX_OTHER, container, 256, 256);
        StandardThemeAssets.addStandardSymbols(DEFAULT, VANILLA_SYMBOLS, container, 256, 256);
        StandardThemeAssets.addFlat14x14Symbols(DEFAULT, VLIB_SYMBOLS_FLAT_14, container, 256, 256);
        StandardThemeAssets.addFlat48x48Symbols(DEFAULT, VLIB_SYMBOLS_FLAT_48, container, 256, 256);
        StandardThemeAssets.addProgressBars(DEFAULT, VLIB_PROGRESS_BARS, container, 256, 256);
        StandardThemeAssets.addProgressBarsOverlays(DEFAULT, VLIB_BAR_OVERLAYS, container, 256, 256);
        StandardThemeAssets.addOtherTextures(DEFAULT, VLIB_TEX_OTHER, container, 256, 256);
        StandardThemeAssets.addGSBVLBackgrounds(DEFAULT, VLIB_GSB_BACKGROUNDS, container, 256, 256);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_CONTAINER_TITLE_TEXT, new Color4(64, 64, 64));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_DEFAULT_IMAGE_COLOR, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_TEXT_FIELD_TEXT_ENA, new Color4(0xE0E0E0));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_TEXT_FIELD_TEXT_DIS, new Color4(0x707070));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_TEXT_FIELD_BORDER, new Color4(-6250336));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_TEXT_FIELD_BG, new Color4(-16777216));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_ICON_ENABLED, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_ICON_DISABLED, Color4.BLACK);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_ICON_HOVER, new Color4(64, 64, 64));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_ICON_SELECTED, Color4.SILVER);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_TEXT_ENABLED, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_TEXT_DISABLED, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_TEXT_HOVER, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_BUTTON_TEXT_SELECTED, Color4.WHITE);
        container.registerColor(DEFAULT, StandardThemeAssets.COL_PROGRESS_BAR, new Color4());
        container.registerColor(DEFAULT, StandardThemeAssets.COL_ENERGY_BAR, new Color4(160, 10, 0));
        container.registerColor(DEFAULT, StandardThemeAssets.COL_FUEL_LEVEL_BAR, new Color4(0, 208, 255));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_CURSEFORGE_WHI, GuiTexture.create(VLIB_LOGOS_CURSEFORGE, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_DISCORD_BLU, GuiTexture.create(VLIB_LOGOS_DISCORD, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_DISCORD_WHI, GuiTexture.create(VLIB_LOGOS_DISCORD, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_DISCORD_BLK, GuiTexture.create(VLIB_LOGOS_DISCORD, 0, 96, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_GITHUB_BLK, GuiTexture.create(VLIB_LOGOS_GITHUB, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_GITHUB_WHI, GuiTexture.create(VLIB_LOGOS_GITHUB, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_PATREON_BLU_ONG, GuiTexture.create(VLIB_LOGOS_PATREON, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_PATREON_BLU_WHI, GuiTexture.create(VLIB_LOGOS_PATREON, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_PATREON_BLK, GuiTexture.create(VLIB_LOGOS_PATREON, 0, 96, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITCH_PUR, GuiTexture.create(VLIB_LOGOS_TWITCH, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITCH_WHI, GuiTexture.create(VLIB_LOGOS_TWITCH, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITCH_BLK, GuiTexture.create(VLIB_LOGOS_TWITCH, 0, 96, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITTER_BLUE, GuiTexture.create(VLIB_LOGOS_TWITTER, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITTER_WHITE, GuiTexture.create(VLIB_LOGOS_TWITTER, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_TWITTER_BLACK, GuiTexture.create(VLIB_LOGOS_TWITTER, 0, 96, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_YOUTUBE_RED_WHI, GuiTexture.create(VLIB_LOGOS_YOUTUBE, 0, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_YOUTUBE_WHI_TS, GuiTexture.create(VLIB_LOGOS_YOUTUBE, 96, 0, 96, 96));
        container.registerTexture(DEFAULT, StandardThemeAssets.TEX_LOGO_YOUTUBE_BLK_WHI, GuiTexture.create(VLIB_LOGOS_YOUTUBE, 0, 96, 96, 96));
    }
}

