/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static void initContainerAll(@NotNull Collection<? extends IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementContainer) {
                ((IElementContainer)((Object)ele)).initContainer();
            }
        });
    }

    public static int getElementsAddedSizeX(@NotNull Collection<? extends IElement> elements) {
        int sizeX = 0;
        for (IElement iElement : elements) {
            sizeX += iElement.getSizeX();
        }
        return sizeX;
    }

    public static int getElementsAddedSizeY(@NotNull Collection<? extends IElement> elements) {
        int sizeY = 0;
        for (IElement iElement : elements) {
            sizeY += iElement.getSizeY();
        }
        return sizeY;
    }

    public static void updateAll(@NotNull Collection<? extends IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementUpdate) {
                ((IElementUpdate)((Object)ele)).update();
            }
        });
    }

    public static void onThemeChangedAll(Theme theme, @NotNull Collection<? extends IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementThemeListener) {
                ((IElementThemeListener)((Object)ele)).onThemeChanged(theme);
            }
        });
    }

    public static void drawBackground(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks, IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBgVisible()) {
                ((IElementDraw)((Object)ele)).renderBg(matrixStack, mouseX, mouseY, partialTicks);
            }
        });
    }

    public static void drawForeground(MatrixStack matrixStack, double mouseX, double mouseY, IElementContainer container, @NotNull List<? extends IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isFgVisible()) {
                ((IElementDraw)((Object)ele)).renderFg(matrixStack, mouseX, mouseY);
            }
        });
    }

    public static void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY, IElementContainer container, @NotNull List<IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDrawTooltip) {
                ((IElementDrawTooltip)((Object)ele)).drawTooltips(matrixStack, mouseX, mouseY);
            }
        });
    }

    public static boolean mouseClickedCheckAll(double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container, @NotNull List<? extends IElement> elements) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        for (IElement iElement : elements) {
            if (!iElement.livesOutsideContainer() && !inCont || !(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).emouseClicked(mouseX, mouseY, mouseButton)) continue;
            r = true;
            container.mouseClickedResponse(iElement, mouseX, mouseY, mouseButton);
        }
        return r;
    }

    public static boolean mouseReleasedCheckAll(double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container, @NotNull List<IElement> elements) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() && !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).emouseReleased(mouseX, mouseY, mouseButton)) continue;
            r = true;
            container.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return r;
    }

    public static boolean mouseDraggedCheckAll(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd, @NotNull IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseXStart, (int)mouseYStart);
        for (IElement iElement : elements) {
            if (!iElement.livesOutsideContainer() && !inCont || !(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).emouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) continue;
            r = true;
            container.mouseDraggedResponse(iElement, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }
        return r;
    }

    public static boolean mouseScrolledCheckAll(double mx, double my, double scrolled, @NotNull IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mx, (int)my);
        for (IElement iElement : elements) {
            if (!iElement.livesOutsideContainer() && !inCont || !(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).emouseScrolled(mx, my, scrolled)) continue;
            r = true;
            container.mouseScrolledResponse(iElement, mx, my, scrolled);
        }
        return r;
    }

    public static boolean keyPressedCheckAll(int key, int scanCode, int modifiers, @NotNull IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        boolean r = false;
        for (IElement iElement : elements) {
            if (!(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).ekeyPressed(key, scanCode, modifiers)) continue;
            r = true;
            container.keyPressedResponse(iElement, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean keyReleasedCheckAll(int key, int scanCode, int modifiers, @NotNull IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        boolean r = false;
        for (IElement iElement : elements) {
            if (!(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).ekeyReleased(key, scanCode, modifiers)) continue;
            r = true;
            container.keyReleasedResponse(iElement, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean charTypedCheckAll(char ch, int modifiers, @NotNull IElementContainer container, @NotNull Collection<? extends IElement> elements) {
        boolean r = false;
        for (IElement iElement : elements) {
            if (!(iElement instanceof IElementInput) || !((IElementInput)((Object)iElement)).echarTyped(ch, modifiers)) continue;
            r = true;
            container.charTypedResponse(iElement, ch, modifiers);
        }
        return r;
    }

    public static void guiScissorStart(int x, int y, int w, int h) {
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        double d = mw.func_198100_s();
        int screenH = mw.func_198091_l();
        int sx = (int)((double)x * d);
        int sy = (int)((double)y * d);
        int sw = (int)((double)w * d);
        int sh = (int)((double)h * d);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)sx, (int)(screenH - sy - sh), (int)sw, (int)sh);
    }

    public static void guiScissorEnd() {
        GL11.glDisable((int)3089);
    }

    public static void out(String data) {
    }

    public static boolean withinBox(double x, double y, double boxX, double boxY, double boxWidth, double boxHeight) {
        return x >= boxX && x < boxX + boxWidth && y >= boxY && y < boxY + boxHeight;
    }

    public static void withinEither(Provider<Boolean> livesOutside, double x, double y, IElement element, Action success) {
        GuiUtils.withinEither(livesOutside, x, y, element.getActualX(), element.getActualY(), element.getSizeX(), element.getSizeY(), element, success);
    }

    public static void withinEitherElse(Provider<Boolean> livesOutside, double x, double y, IElement element, Action success, Action fail) {
        GuiUtils.withinEitherElse(livesOutside, x, y, element.getActualX(), element.getActualY(), element.getSizeX(), element.getSizeY(), element, success, fail);
    }

    public static void withinEither(Provider<Boolean> livesOutside, double x, double y, double boxX, double boxY, double boxWidth, double boxHeight, IElement element, Action success) {
        if (livesOutside.request().booleanValue()) {
            if (GuiUtils.withinBox(x, y, boxX, boxY, boxWidth, boxHeight)) {
                success.execute();
            }
        } else if (element.withinBoxAndGui(x, y, boxX, boxY, boxWidth, boxHeight)) {
            success.execute();
        }
    }

    public static void withinEitherElse(Provider<Boolean> livesOutside, double x, double y, double boxX, double boxY, double boxWidth, double boxHeight, IElement element, Action success, Action fail) {
        if (livesOutside.request().booleanValue()) {
            if (GuiUtils.withinBox(x, y, boxX, boxY, boxWidth, boxHeight)) {
                success.execute();
            } else {
                fail.execute();
            }
        } else if (element.withinBoxAndGui(x, y, boxX, boxY, boxWidth, boxHeight)) {
            success.execute();
        } else {
            fail.execute();
        }
    }

    public static void drawTooltipsList(IElementContainer container, MatrixStack matrixStack, int mouseX, int mouseY, List<ITextComponent> tooltips) {
        container.getGui().func_243308_b(matrixStack, tooltips, mouseX, mouseY);
    }

    public static void drawTexturedRect(AbstractGui obj, MatrixStack matrixStack, int x, int y, int u, int v, int uw, int vh) {
        obj.func_238474_b_(matrixStack, x, y, u, v, uw, vh);
    }

    public static void drawTexturedRect(AbstractGui obj, MatrixStack matrixStack, int x, int y, float u, float v, int uw, int vh, int texWidth, int texHeight) {
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)u, (float)v, (int)uw, (int)vh, (int)texWidth, (int)texHeight);
    }

    public static void drawTexturedRect(AbstractGui obj, MatrixStack matrixStack, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)rendW, (int)rendH, (float)u, (float)v, (int)uw, (int)vh, (int)texWidth, (int)texHeight);
    }

    public static void drawTexturedRectRepeat(AbstractGui obj, MatrixStack matrixStack, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        int cx;
        int yy;
        int xRepeat = rendW / uw;
        int xRepeatR = rendW % uw;
        int yRepeat = rendH / vh;
        int yRepeatR = rendH % vh;
        int currentX = x;
        int currentY = y;
        for (int xx = 0; xx < xRepeat; ++xx) {
            currentX = x + uw * xx;
            for (yy = 0; yy < yRepeat; ++yy) {
                currentY = y + vh * yy;
                GuiUtils.drawTexturedRect(obj, matrixStack, currentX, currentY, (float)u, (float)v, uw, vh, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0) {
            cx = x + xRepeat * uw;
            for (yy = 0; yy < yRepeat; ++yy) {
                int cy = y + vh * yy;
                GuiUtils.drawTexturedRect(obj, matrixStack, cx, cy, u, v, xRepeatR, vh, xRepeatR, vh, texWidth, texHeight);
            }
        }
        if (yRepeatR > 0) {
            int cy = y + yRepeat * vh;
            for (int xx = 0; xx < xRepeat; ++xx) {
                int cx2 = x + uw * xx;
                GuiUtils.drawTexturedRect(obj, matrixStack, cx2, cy, u, v, uw, yRepeatR, uw, yRepeatR, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0 && yRepeatR > 0) {
            cx = x + xRepeat * uw;
            int cy = y + yRepeat * vh;
            GuiUtils.drawTexturedRect(obj, matrixStack, cx, cy, u, v, xRepeatR, yRepeatR, xRepeatR, yRepeatR, texWidth, texHeight);
        }
    }

    public static void drawProgressBar(AbstractGui obj, MatrixStack matrixStack, GuiTexture texture, int x, int y, ProgressionDirection proressDirection, float scale) {
        GuiUtils.bindTexture(texture.texture);
        boolean horizontal = proressDirection == ProgressionDirection.TO_LEFT || proressDirection == ProgressionDirection.TO_RIGHT;
        int xx = proressDirection == ProgressionDirection.TO_LEFT ? texture.width - (int)((float)texture.width * scale) : 0;
        int yy = proressDirection == ProgressionDirection.UPWARD ? texture.height - (int)((float)texture.height * scale) : 0;
        GuiUtils.drawTexturedRect(obj, matrixStack, x + xx, y + yy, texture.startX + xx, texture.startY + yy, horizontal ? (int)((float)texture.width * scale) : texture.width, !horizontal ? (int)((float)texture.height * scale) : texture.height);
    }

    public static void drawProgressBar(MatrixStack matrixStack, Color4 color, GuiTexture texture, int x, int y, ProgressionDirection proressDirection, float scale) {
        GuiUtils.bindTexture(texture.texture);
        boolean horizontal = proressDirection == ProgressionDirection.TO_LEFT || proressDirection == ProgressionDirection.TO_RIGHT;
        int xx = proressDirection == ProgressionDirection.TO_LEFT ? texture.width - (int)((float)texture.width * scale) : 0;
        int yy = proressDirection == ProgressionDirection.UPWARD ? texture.height - (int)((float)texture.height * scale) : 0;
        GuiUtils.drawTexturedRect(matrixStack, color, x + xx, y + yy, texture.startX + xx, texture.startY + yy, horizontal ? (int)((float)texture.width * scale) : texture.width, !horizontal ? (int)((float)texture.height * scale) : texture.height);
    }

    public static void drawFluidBar(FluidStack fluid, int tankCapacity, double x, double y, double width, double height) {
        int amount = fluid.getAmount();
        if (fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = GuiUtils.getFluidTexture(fluid);
        if (icon == null) {
            return;
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)tankCapacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        int color = fluid.getFluid().getAttributes().getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color3f((float)r, (float)g, (float)b);
        RenderSystem.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                float minV = icon.func_94206_g();
                float maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_225582_a_((double)drawX, (double)(drawY + drawHeight), 0.0).func_225583_a_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                tes.func_225582_a_((double)(drawX + drawWidth), (double)drawY, 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).func_181675_d();
                tes.func_225582_a_((double)drawX, (double)drawY, 0.0).func_225583_a_(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        RenderSystem.disableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        TextureAtlasSprite[] textures = GuiUtils.getFluidSprites((World)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a, fluid.getFluid().func_207188_f());
        return textures.length > 0 ? textures[0] : null;
    }

    public static TextureAtlasSprite[] getFluidSprites(World world, BlockPos pos, FluidState fluidStateIn) {
        ResourceLocation overlayTexture = fluidStateIn.func_206886_c().getAttributes().getOverlayTexture();
        return new TextureAtlasSprite[]{(TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStateIn.func_206886_c().getAttributes().getStillTexture((IBlockDisplayReader)world, pos)), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStateIn.func_206886_c().getAttributes().getFlowingTexture((IBlockDisplayReader)world, pos)), overlayTexture == null ? null : (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(overlayTexture)};
    }

    public static void drawGuiTexture(AbstractGui obj, MatrixStack matrixStack, GuiTexture texture, int x, int y, int width, int height) {
        GuiUtils.bindTexture(texture.texture);
        GuiUtils.drawTexturedRect(obj, matrixStack, x, y, texture.startX, texture.startY, texture.width, texture.height, width, height, texture.getTexW(), texture.getTexH());
    }

    public static void drawGuiTexture(MatrixStack matrixStack, GuiTexture texture, Color4 color4, int x, int y, int width, int height) {
        GuiUtils.bindTexture(texture.texture);
        GuiUtils.drawTexturedRect(matrixStack, color4, x, y, texture.startX, texture.startY, texture.width, texture.height, width, height, texture.getTexW(), texture.getTexH());
    }

    public static void enableStandardItemLighting() {
        RenderHelper.func_227780_a_();
    }

    public static void disableStandardItemLighting() {
        RenderHelper.func_74518_a();
    }

    public static void renderTexture(AbstractGui obj, MatrixStack matrixStack, GuiTexture tex, IElementContainer gui, int x, int y) {
        GuiUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(obj, matrixStack, x, y, tex.startX, tex.startY, tex.width, tex.height);
    }

    public static void renderTexture(AbstractGui obj, MatrixStack matrixStack, GuiTexture tex, IElementContainer gui, int x, int y, int w, int h) {
        GuiUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(obj, matrixStack, x, y, (float)tex.startX, (float)tex.startY, tex.width, tex.height, w, h);
    }

    protected static void bindTexture(VLID res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)res);
    }

    public static void drawTexturedRect(MatrixStack matrixStack, Color4 color4, int x, int y, int u, int v, int uw, int vh) {
        GuiUtils.blit(matrixStack, color4, x, y, u, v, uw, vh, 256, 256);
    }

    public static void drawTexturedRect(MatrixStack matrixStack, Color4 color4, int x, int y, float u, float v, int uw, int vh, int texWidth, int texHeight) {
        GuiUtils.blit(matrixStack, color4, x, y, u, v, uw, vh, texWidth, texHeight);
    }

    public static void drawTexturedRect(MatrixStack matrixStack, Color4 color4, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        GuiUtils.blit(matrixStack, color4, x, y, rendW, rendH, u, v, uw, vh, texWidth, texHeight);
    }

    public static void blit(MatrixStack matrix, Color4 color4, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite) {
        GuiUtils.innerBlit(matrix.func_227866_c_().func_227870_a_(), color4, x, x + width, y, y + height, blitOffset, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
    }

    public static void blit(MatrixStack matrix, Color4 color4, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureHeight, int textureWidth) {
        GuiUtils.innerBlit(matrix, color4, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void blit(MatrixStack matrix, Color4 color4, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiUtils.innerBlit(matrix, color4, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void blit(MatrixStack matrix, Color4 color4, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        GuiUtils.blit(matrix, color4, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    private static void innerBlit(MatrixStack matrix, Color4 color4, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        GuiUtils.innerBlit(matrix.func_227866_c_().func_227870_a_(), color4, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    private static void innerBlit(Matrix4f matrix, Color4 color4, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        float r = color4.getR();
        float g = color4.getG();
        float b = color4.getB();
        float a = color4.getA();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)blitOffset).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void drawTexturedRectRepeat(MatrixStack matrixStack, Color4 color4, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        int cx;
        int yy;
        int xRepeat = rendW / uw;
        int xRepeatR = rendW % uw;
        int yRepeat = rendH / vh;
        int yRepeatR = rendH % vh;
        int currentX = x;
        int currentY = y;
        for (int xx = 0; xx < xRepeat; ++xx) {
            currentX = x + uw * xx;
            for (yy = 0; yy < yRepeat; ++yy) {
                currentY = y + vh * yy;
                GuiUtils.drawTexturedRect(matrixStack, color4, currentX, currentY, (float)u, (float)v, uw, vh, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0) {
            cx = x + xRepeat * uw;
            for (yy = 0; yy < yRepeat; ++yy) {
                int cy = y + vh * yy;
                GuiUtils.drawTexturedRect(matrixStack, color4, cx, cy, u, v, xRepeatR, vh, xRepeatR, vh, texWidth, texHeight);
            }
        }
        if (yRepeatR > 0) {
            int cy = y + yRepeat * vh;
            for (int xx = 0; xx < xRepeat; ++xx) {
                int cx2 = x + uw * xx;
                GuiUtils.drawTexturedRect(matrixStack, color4, cx2, cy, u, v, uw, yRepeatR, uw, yRepeatR, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0 && yRepeatR > 0) {
            cx = x + xRepeat * uw;
            int cy = y + yRepeat * vh;
            GuiUtils.drawTexturedRect(matrixStack, color4, cx, cy, u, v, xRepeatR, yRepeatR, xRepeatR, yRepeatR, texWidth, texHeight);
        }
    }
}

