/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.stack;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class ItemStackSequenceElement
extends VLElement
implements IElementDraw,
IElementDrawTooltip,
IElementUpdate {
    protected List<ItemStack> stacks;
    protected int ticks = 0;
    protected int ticksPerItem = 20;
    protected ItemStack currentItem = ItemStack.field_190927_a;
    protected int currentIndex = 0;
    protected boolean drawToolTip = true;
    protected boolean renderStackSize = false;
    protected FontRenderer textRenderer;

    public static ItemStackSequenceElement from(String id, Collection<IItemProvider> items) {
        ArrayList stacks = Lists.newArrayList();
        items.forEach(iItemProvider -> stacks.add(new ItemStack(iItemProvider)));
        return new ItemStackSequenceElement(id, stacks);
    }

    public ItemStackSequenceElement(String id, Collection<ItemStack> stacks) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = stacks != null && !stacks.isEmpty() ? Lists.newArrayList(stacks) : Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    public ItemStackSequenceElement(String id, ItemStack stack) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = stack != null ? Lists.newArrayList((Object[])new ItemStack[]{stack}) : Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    public ItemStackSequenceElement(String id) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    public void setDrawToolTip(boolean opt) {
        this.drawToolTip = opt;
    }

    public ItemStackSequenceElement setTicksPerItem(int t) {
        this.ticksPerItem = t;
        return this;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        GuiUtils.enableStandardItemLighting();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(this.currentItem, this.getActualX(), this.getActualY());
        if (this.renderStackSize) {
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.textRenderer, this.currentItem, this.getActualX(), this.getActualY(), "" + this.currentItem.func_190916_E());
        }
        GuiUtils.disableStandardItemLighting();
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
        if (!this.drawToolTip) {
            return;
        }
        if (this.withinBoxAndGui(mouseX, mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY())) {
            boolean advancedItemTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
            ITooltipFlag.TooltipFlags flag = advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            GuiUtils.drawTooltipsList(this.getContainer(), matrixStack, (int)mouseX, (int)mouseY, this.currentItem.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)flag));
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        return 16;
    }

    @Override
    public int getSizeY() {
        return 16;
    }

    @Override
    public void update() {
        ++this.ticks;
        if (this.ticks >= this.ticksPerItem) {
            this.ticks = 0;
            ++this.currentIndex;
            if (this.currentIndex >= this.stacks.size()) {
                this.currentIndex = 0;
            }
            this.currentItem = this.stacks.get(this.currentIndex);
            if (this.currentItem == null) {
                this.currentItem = ItemStack.field_190927_a;
            }
        }
    }
}

