/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.rateconfig;

import com.valkyrieofnight.vlib.VLib;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IConfigurableIORate;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IHasRateConfigSideMenu;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.RateConfigPacket;
import com.valkyrieofnight.vlib.core.ui.client.VLContainerScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.IndexElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.IconButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.TextButton;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.rateconfig.RateConfigElementProperties;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.AbstractTextBoxElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.TextBoxElement;
import com.valkyrieofnight.vlib.core.ui.container.VLContainer;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.LocalizationUtils;
import com.valkyrieofnight.vlib.core.util.convenience.IToggleable;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.math.NumberUtils;

public class RateConfigSideMenuElement
extends FixedContainerElement {
    public static final String BUTTON_ID = "rate_config";
    protected VLContainerScreen<?> screen;
    protected VLContainer container;
    protected TileEntity tile;
    protected IndexElement mode;
    protected ButtonElement sideButton;
    protected TextButton toggleCapabilityButton;
    protected TextButton setModeInputButton;
    protected TextButton setModeOutputButton;
    protected AbstractTextBoxElement textBoxElement;
    protected ButtonElement setRateZeroButton;
    protected ButtonElement decreaseRateButton;
    protected ButtonElement increaseRateButton;
    protected ButtonElement setRateMaxButton;
    protected Provider<Integer> gx;
    protected Provider<Integer> gy;
    protected int buttonX;
    protected int buttonY;
    protected IHasRateConfigSideMenu rateConfigContainer;
    protected List<IConfigurableIORate> allRateConfigs;
    protected IConfigurableIORate currentRateConfig;
    protected List<Capability<?>> supportedCapabilities;
    protected boolean toggleCapabilityButtonEnabled;
    protected boolean setModeInputButtonEnabled;
    protected boolean setModeOutputButtonEnabled;
    protected boolean isShiftPressed = false;
    protected boolean isAltPressed = false;
    List<Integer> allSlots;

    public RateConfigSideMenuElement(String id, VLContainerScreen<?> screen, VLContainer container, TileEntity tile, int buttonX, int buttonY) {
        super(id, 0, 0);
        this.screen = screen;
        this.container = container;
        this.gx = screen::getSizeX;
        this.gy = screen::getSizeY;
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.tile = tile;
    }

    @Override
    public boolean livesOutsideContainer() {
        return true;
    }

    @Override
    public void addElements() {
        this.sideButton = new ContainerButtonElement("toggle_rate_config", 12, 12){

            @Override
            public void addElements() {
                this.addElementEach(new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_HOV), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_SEL), 0, 0);
            }

            @Override
            public boolean livesOutsideContainer() {
                return true;
            }
        };
        this.addElement(this.sideButton, this.buttonX, this.buttonY);
        this.sideButton.addToolTip((ITextComponent)LocalizationUtils.getLocalizedButtonToolTipFromID(BUTTON_ID));
        this.mode = new IndexElement(BUTTON_ID){

            @Override
            public void addIndices() {
                this.addIndex(new FixedContainerElement("disabled", 0, 0){

                    @Override
                    public void addElements() {
                        this.addElement(new MaxScaledImageElement("disabled", StandardThemeAssets.TEX_EIGHTY_PERCENT_DIS, 8, 8), RateConfigSideMenuElement.this.buttonX + 2, RateConfigSideMenuElement.this.buttonY + 2);
                    }

                    @Override
                    public int getSizeX() {
                        return RateConfigSideMenuElement.this.gx.request();
                    }

                    @Override
                    public int getSizeY() {
                        return RateConfigSideMenuElement.this.gy.request();
                    }
                });
                this.addIndex(new FixedContainerElement("enabled", 0, 0){

                    @Override
                    public void addElements() {
                        this.addElement(new MaxScaledImageElement("enabled", StandardThemeAssets.TEX_EIGHTY_PERCENT_ENA, 8, 8), RateConfigSideMenuElement.this.buttonX + 2, RateConfigSideMenuElement.this.buttonY + 2);
                        if (RateConfigSideMenuElement.this.tile instanceof IHasRateConfigSideMenu) {
                            RateConfigSideMenuElement.this.rateConfigContainer = (IHasRateConfigSideMenu)RateConfigSideMenuElement.this.tile;
                            RateConfigSideMenuElement.this.allRateConfigs = RateConfigSideMenuElement.this.rateConfigContainer.getRateConfigs();
                            RateConfigSideMenuElement.this.currentRateConfig = RateConfigSideMenuElement.this.allRateConfigs.get(0);
                            this.addElement(new SizablePanelElement("rate_config_background", StandardThemeAssets.GSB_VANILLA_CONTAINER, RateConfigElementProperties.getBackgroundWidth(), RateConfigElementProperties.getBackgroundHeight()), RateConfigSideMenuElement.this.buttonX + 12, RateConfigSideMenuElement.this.buttonY + 0);
                            RateConfigSideMenuElement.this.toggleCapabilityButton = new TextButton("config_type", RateConfigElementProperties.getSetTypeButtonWidth(), 12);
                            this.addElement(RateConfigSideMenuElement.this.toggleCapabilityButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 0, 1), RateConfigElementProperties.getSetTypeButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.toggleCapabilityButton.setOwner(this);
                            RateConfigSideMenuElement.this.setModeInputButton = new TextButton("set_mode_input", RateConfigElementProperties.getSetModeButtonWidth(2), 12);
                            this.addElement(RateConfigSideMenuElement.this.setModeInputButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 0, 2), RateConfigElementProperties.getSetModeButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.setModeOutputButton = new TextButton("set_mode_output", RateConfigElementProperties.getSetModeButtonWidth(2), 12);
                            this.addElement(RateConfigSideMenuElement.this.setModeOutputButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 1, 2), RateConfigElementProperties.getSetModeButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.setModeInputButton.setOwner(this);
                            RateConfigSideMenuElement.this.setModeOutputButton.setOwner(this);
                            RateConfigSideMenuElement.this.setRateZeroButton = new IconButtonElement("set_rate_zero", 18, 12, StandardThemeAssets.TEX_SYM_FLAT_14_ZERO);
                            this.addElement(RateConfigSideMenuElement.this.setRateZeroButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 0, 4), RateConfigElementProperties.getRateControlButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.decreaseRateButton = new IconButtonElement("decrease_rate", 18, 12, StandardThemeAssets.TEX_SYM_FLAT_14_MINUS);
                            this.addElement(RateConfigSideMenuElement.this.decreaseRateButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 1, 4), RateConfigElementProperties.getRateControlButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.increaseRateButton = new IconButtonElement("increase_rate", 18, 12, StandardThemeAssets.TEX_SYM_FLAT_14_PLUS);
                            this.addElement(RateConfigSideMenuElement.this.increaseRateButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 2, 4), RateConfigElementProperties.getRateControlButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.setRateMaxButton = new IconButtonElement("set_rate_infinite", 18, 12, StandardThemeAssets.TEX_SYM_FLAT_14_INFINITY);
                            this.addElement(RateConfigSideMenuElement.this.setRateMaxButton, RateConfigElementProperties.getButtonXOffset(RateConfigSideMenuElement.this.buttonX, 3, 4), RateConfigElementProperties.getRateControlButtonsYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.textBoxElement = new TextBoxElement("rate_text_box", RateConfigElementProperties.getTextBoxWidth(), RateConfigElementProperties.getTextBoxHeight(), "", StandardThemeAssets.COL_TEXT_FIELD_TEXT_ENA, StandardThemeAssets.COL_TEXT_FIELD_TEXT_DIS, StandardThemeAssets.COL_TEXT_FIELD_BG, StandardThemeAssets.COL_TEXT_FIELD_BORDER){

                                @Override
                                public void onFocusChanged(boolean focused) {
                                    RateConfigSideMenuElement.this.updateTextBox(!focused);
                                    super.onFocusChanged(focused);
                                }
                            };
                            this.addElement(RateConfigSideMenuElement.this.textBoxElement, RateConfigElementProperties.getTextBoxXOffset(RateConfigSideMenuElement.this.buttonX), RateConfigElementProperties.getTextBoxYOffset(RateConfigSideMenuElement.this.buttonY));
                            RateConfigSideMenuElement.this.setupElements();
                        }
                    }

                    @Override
                    public int getSizeX() {
                        return RateConfigSideMenuElement.this.gx.request();
                    }

                    @Override
                    public int getSizeY() {
                        return RateConfigSideMenuElement.this.gy.request();
                    }
                });
            }
        };
        this.addElement(this.mode, 0, 0);
    }

    @Override
    public int getSizeX() {
        return this.gx.request();
    }

    @Override
    public int getSizeY() {
        return this.gy.request();
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.onRightMouseClick(mouseX, mouseY);
        } else if (this.sideButton.equals(element)) {
            this.onSideButtonToggle();
        } else if (this.toggleCapabilityButton.equals(element)) {
            this.onToggleCapabilityButtonClicked();
        } else if (this.setModeInputButton.equals(element)) {
            this.onSetModeInputButtonClicked();
        } else if (this.setModeOutputButton.equals(element)) {
            this.onSetModeOutputButtonClicked();
        } else if (this.textBoxElement.equals(element)) {
            this.onTextBoxClicked(mouseButton);
        } else if (this.setRateZeroButton.equals(element)) {
            this.onSetRateZeroButtonClicked();
        } else if (this.decreaseRateButton.equals(element)) {
            this.onDecreaseRateButtonClicked();
        } else if (this.increaseRateButton.equals(element)) {
            this.onIncreaseRateButtonClicked();
        } else if (this.setRateMaxButton.equals(element)) {
            this.onSetRateMaxButtonClicked();
        }
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        switch (key) {
            case 340: 
            case 344: {
                this.isShiftPressed = true;
                break;
            }
            case 342: 
            case 346: {
                this.isAltPressed = true;
            }
        }
        return super.ekeyPressed(key, scanCode, modifiers);
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        switch (key) {
            case 257: 
            case 335: {
                if (!this.textBoxElement.isFocused()) break;
                this.textBoxElement.onFocusChanged(false);
                break;
            }
            case 340: 
            case 344: {
                this.isShiftPressed = false;
                break;
            }
            case 342: 
            case 346: {
                this.isAltPressed = false;
            }
        }
        return super.ekeyReleased(key, scanCode, modifiers);
    }

    void updateEnabledButtons() {
        boolean bothEnabled;
        this.toggleCapabilityButtonEnabled = this.supportedCapabilities.size() > 1;
        this.toggleCapabilityButton.setEnabled(this.toggleCapabilityButtonEnabled);
        this.setModeInputButtonEnabled = this.currentRateConfig.isModeSupported(IOMode.IN);
        this.setModeOutputButtonEnabled = this.currentRateConfig.isModeSupported(IOMode.OUT);
        boolean bl = bothEnabled = this.setModeInputButtonEnabled && this.setModeOutputButtonEnabled;
        if (!bothEnabled) {
            this.setModeInputButton.setEnabled(false);
            this.setModeOutputButton.setEnabled(false);
            if (this.setModeInputButtonEnabled) {
                this.setModeInputButton.setDisabledButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
                this.setModeOutputButton.setDisabledButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS);
            }
            if (this.setModeOutputButtonEnabled) {
                this.setModeOutputButton.setDisabledButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
                this.setModeInputButton.setDisabledButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS);
            }
        }
    }

    void updateToggleConfigTypeButtonText() {
        this.toggleCapabilityButton.setText((ITextComponent)LocalizationUtils.getLocalizedButtonLabelFromID(this.currentRateConfig.getID()));
    }

    void updateTextBox(boolean use_words) {
        int currentRate = this.currentRateConfig.getRate();
        String text = use_words ? (currentRate == Integer.MAX_VALUE ? LocalizationUtils.getLocalizedTextFromID("infinite").getString() : (this.currentRateConfig.isRateMax() && currentRate != 0 ? LocalizationUtils.getLocalizedTextFromID("max").getString() : String.valueOf(currentRate))) : String.valueOf(currentRate);
        this.textBoxElement.setText(text);
    }

    void setupElements() {
        this.setRateZeroButton.addToolTip((ITextComponent)LocalizationUtils.getLocalizedButtonToolTipFromID("set_rate_zero"));
        this.decreaseRateButton.addToolTip((ITextComponent)LocalizationUtils.getLocalizedButtonToolTipFromID("decrease_rate"));
        this.increaseRateButton.addToolTip((ITextComponent)LocalizationUtils.getLocalizedButtonToolTipFromID("increase_rate"));
        this.setRateMaxButton.addToolTip((ITextComponent)LocalizationUtils.getLocalizedButtonToolTipFromID("set_rate_max"));
        this.supportedCapabilities = this.rateConfigContainer.getSupportedCapabilities();
        this.updateToggleConfigTypeButtonText();
        this.setModeInputButton.setText((ITextComponent)LocalizationUtils.getLocalizedButtonLabelFromID("input"));
        this.setModeOutputButton.setText((ITextComponent)LocalizationUtils.getLocalizedButtonLabelFromID("output"));
        this.toggleCapabilityButton.setDisabledButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
        this.toggleModeButtonFocus();
        this.setModeInputButton.setSelectedButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
        this.setModeOutputButton.setSelectedButtonBackground(StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
        this.setModeInputButton.setEnabledTextColor(StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.setModeOutputButton.setEnabledTextColor(StandardThemeAssets.COL_CONTAINER_TITLE_TEXT);
        this.updateEnabledButtons();
        this.textBoxElement.setResponder(this::onTextBoxChanged);
        this.textBoxElement.setValidator(this::validateText);
        this.onRateChanged(true);
    }

    protected void onSideConfigOpen() {
        if (this.allSlots == null) {
            this.allSlots = new ArrayList<Integer>();
            for (int i = 0; i < this.container.field_75151_b.size() - 36; ++i) {
                this.allSlots.add(i);
            }
        }
        this.container.blockInteraction(this.allSlots);
        for (int i : this.allSlots) {
            Slot s = this.container.func_75139_a(i);
            if (!(s instanceof IToggleable)) continue;
            ((IToggleable)s).setActive(false);
        }
    }

    protected void onSideConfigClose() {
        if (this.allSlots == null) {
            this.allSlots = new ArrayList<Integer>();
            for (int i = 0; i < this.container.field_75151_b.size() - 36; ++i) {
                this.allSlots.add(i);
            }
        }
        this.container.resetBlockedSlots();
        for (int i : this.allSlots) {
            Slot s = this.container.func_75139_a(i);
            if (!(s instanceof IToggleable)) continue;
            ((IToggleable)s).setActive(true);
        }
    }

    protected void onSideButtonToggle() {
        if (this.mode.getNumberIndex() == 0) {
            this.mode.setIndex(1);
            this.onSideConfigOpen();
        } else {
            this.mode.setIndex(0);
            this.onSideConfigClose();
        }
    }

    void toggleModeButtonFocus() {
        this.setModeInputButton.onFocusChanged(this.currentRateConfig.getIOMode() == IOMode.IN);
        this.setModeOutputButton.onFocusChanged(this.currentRateConfig.getIOMode() == IOMode.OUT);
    }

    void onToggleCapabilityButtonClicked() {
        if (this.toggleCapabilityButtonEnabled) {
            int currentRateConfigIndex = this.allRateConfigs.indexOf(this.currentRateConfig);
            this.currentRateConfig = this.allRateConfigs.get(currentRateConfigIndex + 1 == this.allRateConfigs.size() ? 0 : currentRateConfigIndex + 1);
            this.onCapabilityChanged();
        }
    }

    void onCapabilityChanged() {
        this.updateEnabledButtons();
        this.updateToggleConfigTypeButtonText();
        this.onConfigChanged();
    }

    void onConfigChanged() {
        this.onRateChanged(true);
    }

    void onRateChanged(boolean update_text_box) {
        boolean increaseRateEnabled = !this.currentRateConfig.isRateMax();
        this.increaseRateButton.setEnabled(increaseRateEnabled);
        this.setRateMaxButton.setEnabled(increaseRateEnabled);
        boolean decreaseRateEnabled = this.currentRateConfig.getRate() != 0;
        this.setRateZeroButton.setEnabled(decreaseRateEnabled);
        this.decreaseRateButton.setEnabled(decreaseRateEnabled);
        VLib.NETWORK_HANDLER.sendToServer(new RateConfigPacket(this.tile.func_174877_v(), this.rateConfigContainer.saveRateConfigs()));
        if (update_text_box) {
            this.updateTextBox(true);
        }
    }

    void onModeChanged() {
        this.toggleModeButtonFocus();
        this.onConfigChanged();
    }

    void onRightMouseClick(double mouseX, double mouseY) {
        if (mouseX - (double)this.textBoxElement.getActualX() < (double)this.textBoxElement.getSizeX() && mouseX - (double)this.textBoxElement.getActualX() > 0.0 && mouseY - (double)this.textBoxElement.getActualY() < (double)this.textBoxElement.getSizeY() && mouseY - (double)this.textBoxElement.getActualY() >= 0.0) {
            this.onTextBoxClicked(1);
        }
    }

    void onSetModeInputButtonClicked() {
        if (this.setModeInputButtonEnabled) {
            this.currentRateConfig.setCurrentIOMode(IOMode.IN);
            this.onModeChanged();
        }
    }

    void onSetModeOutputButtonClicked() {
        if (this.setModeOutputButtonEnabled) {
            this.currentRateConfig.setCurrentIOMode(IOMode.OUT);
            this.onModeChanged();
        }
    }

    void onTextBoxClicked(int mouseButton) {
        switch (mouseButton) {
            case 0: {
                break;
            }
            case 1: {
                this.textBoxElement.setText("");
            }
        }
    }

    void onTextBoxChanged(String text) {
        try {
            int rate = Integer.parseInt(text);
            this.currentRateConfig.setRate(rate);
            this.onRateChanged(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    boolean validateText(String s) {
        return NumberUtils.isParsable((String)s) || s.isEmpty() || s.equals(LocalizationUtils.getLocalizedTextFromID("max").getString()) || s.equals(LocalizationUtils.getLocalizedTextFromID("infinite").getString());
    }

    void onSetRateZeroButtonClicked() {
        this.currentRateConfig.setRate(0);
        this.onRateChanged(true);
    }

    void onDecreaseRateButtonClicked() {
        int rate = 100;
        if (this.isShiftPressed && this.isAltPressed) {
            rate = 10000;
        } else if (this.isShiftPressed) {
            rate = 1000;
        } else if (this.isAltPressed) {
            rate = 10;
        }
        this.currentRateConfig.decreaseRate(rate);
        this.onRateChanged(true);
    }

    void onIncreaseRateButtonClicked() {
        int rate = 100;
        if (this.isShiftPressed && this.isAltPressed) {
            rate = 10000;
        } else if (this.isShiftPressed) {
            rate = 1000;
        } else if (this.isAltPressed) {
            rate = 10;
        }
        this.currentRateConfig.increaseRate(rate);
        this.onRateChanged(true);
    }

    void onSetRateMaxButtonClicked() {
        this.currentRateConfig.setRate(this.currentRateConfig.getMaxRate());
        this.onRateChanged(true);
    }
}

