/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base;

import com.valkyrieofnight.vlib.core.ui.client.screen.IVLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import java.util.List;

public abstract class BaseContainerElement
extends VLElement
implements IElementContainer,
IElementDraw,
IElementInput {
    public BaseContainerElement(String id) {
        super(id);
    }

    @Override
    public final void initContainer() {
        this.addElements();
        GuiUtils.initContainerAll(this.getElementList());
    }

    @Override
    public IVLScreen getScreen() {
        return this.getContainer().getScreen();
    }

    @Override
    public final Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public final void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(current, this.getElementList());
    }

    @NotNull
    protected abstract List<IElement> getElementList();

    public abstract void addElements();

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseClickedCheckAll(mouseX, mouseY, mouseButton, this, this.getElementList());
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseReleasedCheckAll(mouseX, mouseY, mouseButton, this, this.getElementList());
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        GuiUtils.mouseDraggedCheckAll(mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll, this, this.getElementList());
        return this.withinBounds((int)mouseX, (int)mouseY);
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        return GuiUtils.mouseScrolledCheckAll(mouseX, mouseY, scrolled, this, this.getElementList());
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        return GuiUtils.keyPressedCheckAll(key, scanCode, modifiers, this, this.getElementList());
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        return GuiUtils.keyReleasedCheckAll(key, scanCode, modifiers, this, this.getElementList());
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        return GuiUtils.charTypedCheckAll(ch, modifiers, this, this.getElementList());
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseReleasedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        this.getContainer().mouseDraggedResponse(element, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
        this.getContainer().mouseScrolledResponse(element, mouseX, mouseY, scrolled);
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyPressedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyReleasedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
        this.getContainer().charTypedResponse(element, ch, modifiers);
    }
}

