/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public abstract class ScissorContainerElement
extends FixedContainerElement {
    protected int xScroll = 0;
    protected int yScroll = 0;
    protected int xScrollMin = 0;
    protected int xScrollMax = 0;
    protected int yScrollMin = 0;
    protected int yScrollMax = 0;

    public ScissorContainerElement(String id, int xSize, int ySize) {
        super(id, xSize, ySize);
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        GuiUtils.guiScissorStart(this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
        GuiUtils.drawBackground(matrixStack, mouseX, mouseY, partialTicks, this, this.elementsList);
        GuiUtils.guiScissorEnd();
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        GuiUtils.guiScissorStart(this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
        GuiUtils.drawForeground(matrixStack, mouseX, mouseY, this, this.elementsList);
        GuiUtils.guiScissorEnd();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return ((ElementPosition)this.elements.get(ele)).getX() - this.xScroll;
        }
        return -this.xScroll;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return ((ElementPosition)this.elements.get(ele)).getY() - this.yScroll;
        }
        return -this.yScroll;
    }

    public int getXScrollMax() {
        return Math.max(0, this.xScrollMax - this.xScrollMin);
    }

    public int getYScrollMax() {
        return Math.max(0, this.yScrollMax - this.yScrollMin);
    }

    public void resetScroll() {
        this.xScroll = 0;
        this.yScroll = 0;
    }

    public void onScrollHorizontal(float scrollProgress) {
        this.xScroll = MathUtil.clamp((int)((float)this.getXScrollMax() * scrollProgress), this.xScrollMin, this.xScrollMax);
    }

    public void onScrollVertical(float scrollProgress) {
        this.yScroll = MathUtil.clamp((int)((float)this.getYScrollMax() * scrollProgress), this.yScrollMin, this.yScrollMax);
    }

    public int getXScroll() {
        return this.xScroll;
    }

    public int getYScroll() {
        return this.yScroll;
    }

    public void setYScroll(int amt) {
        this.yScroll = MathUtil.clamp(amt, this.yScrollMin, this.getYScrollMax());
    }

    public void setXScroll(int amt) {
        this.xScroll = MathUtil.clamp(amt, this.xScrollMin, this.getXScrollMax());
    }

    public void addYScroll(int amt) {
        this.yScroll = MathUtil.clamp(this.yScroll + amt, this.yScrollMin, this.getYScrollMax());
    }

    public void addXScroll(int amt) {
        this.xScroll = MathUtil.clamp(this.xScroll + amt, this.xScrollMin, this.getXScrollMax());
    }

    public void setScrollMin(int xScrollMin, int yScrollMin) {
        this.xScrollMin = Math.min(xScrollMin, 0);
        this.yScrollMin = Math.min(yScrollMin, 0);
    }

    public void setScrollMax(int xScrollMax, int yScrollMax) {
        this.xScrollMax = Math.max(xScrollMax - this.getSizeX(), 0);
        this.yScrollMax = Math.max(yScrollMax - this.getSizeY(), 0);
    }

    public void setXScrollMax(int xScrollMax) {
        this.xScrollMax = Math.max(xScrollMax - this.getSizeX(), 0);
    }

    public void setYScrollMax(int yScrollMax) {
        this.yScrollMax = Math.max(yScrollMax - this.getSizeY(), 0);
    }

    public void setXScrollMin(int xScrollMax) {
        this.xScrollMin = Math.min(this.xScrollMin, 0);
    }

    public void setYScrollMin(int yScrollMax) {
        this.yScrollMin = Math.min(this.yScrollMin, 0);
    }

    public float getZoomDiv() {
        return 10.0f;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        switch (key) {
            case 87: {
                this.addYScroll(-10);
                break;
            }
            case 83: {
                this.addYScroll(10);
                break;
            }
            case 65: {
                this.addXScroll(-10);
                break;
            }
            case 68: {
                this.addXScroll(10);
            }
        }
        return GuiUtils.keyPressedCheckAll(key, scanCode, modifiers, this, this.getElementList());
    }
}

