/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.button;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;

public class IconButtonElement
extends ContainerButtonElement {
    protected SizableBGElement ebg;
    protected MaxScaledImageElement ei;
    protected SizableBGElement dbg;
    protected MaxScaledImageElement di;
    protected SizableBGElement hbg;
    protected MaxScaledImageElement hi;
    protected SizableBGElement sbg;
    protected MaxScaledImageElement si;

    public IconButtonElement(String id, int xSize, int ySize, AssetID enabledIcon, AssetID disabledIcon, AssetID hoverIcon, AssetID selectedIcon) {
        super(id, xSize, ySize);
        int ix = xSize / 2;
        int iy = ySize / 2;
        this.ei = new MaxScaledImageElement("ic", enabledIcon, ix, iy);
        this.di = new MaxScaledImageElement("ic", disabledIcon, ix, iy);
        this.hi = new MaxScaledImageElement("ic", hoverIcon, ix, iy);
        this.si = new MaxScaledImageElement("ic", selectedIcon, ix, iy);
    }

    public IconButtonElement(String id, int xSize, int ySize, AssetID icon) {
        this(id, xSize, ySize, icon, icon, icon, icon);
    }

    public IconButtonElement(String id, int xSize, int ySize, AssetID icon, AssetID enabledColor, AssetID disabledColor, AssetID hoverColor, AssetID selectedColor) {
        this(id, xSize, ySize, icon, icon, icon, icon);
        this.ei.setColor(enabledColor);
        this.di.setColor(disabledColor);
        this.hi.setColor(hoverColor);
        this.si.setColor(selectedColor);
    }

    @Override
    public void addElements() {
        int ix = this.xSize / 2;
        int iy = this.ySize / 2;
        VAlignment va = VAlignment.CENTER;
        HAlignment ha = HAlignment.CENTER;
        this.ebg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
        this.dbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS);
        this.hbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_HOV);
        this.sbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_SEL);
        this.addElementEach(this.ebg, this.dbg, this.hbg, this.sbg, 0, 0);
        this.addElementEach(this.ei, this.di, this.hi, this.si, ix, iy);
        this.ei.setHorizontalAlignment(ha);
        this.ei.setVerticalAlignment(va);
        this.di.setHorizontalAlignment(ha);
        this.di.setVerticalAlignment(va);
        this.hi.setHorizontalAlignment(ha);
        this.hi.setVerticalAlignment(va);
        this.si.setHorizontalAlignment(ha);
        this.si.setVerticalAlignment(va);
    }

    protected IconButtonElement setBG(@Nullable AssetID enabled, @Nullable AssetID disabled, @Nullable AssetID hover, @Nullable AssetID selected) {
        if (enabled != null) {
            this.ebg.setBox(enabled);
        }
        if (disabled != null) {
            this.dbg.setBox(disabled);
        }
        if (hover != null) {
            this.hbg.setBox(hover);
        }
        if (selected != null) {
            this.sbg.setBox(selected);
        }
        return this;
    }

    public IconButtonElement setColors(AssetID enabled, AssetID disabled, AssetID hover, AssetID selected) {
        this.ei.setColor(enabled);
        this.di.setColor(disabled);
        this.hi.setColor(hover);
        this.si.setColor(selected);
        return this;
    }
}

