/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.fluid.base;

import com.valkyrieofnight.vlib.core.obj.block.VLFlowingFluidBlock;
import com.valkyrieofnight.vlib.core.obj.block.base.BlockProps;
import com.valkyrieofnight.vlib.core.obj.fluid.VLFlowingFluid;
import com.valkyrieofnight.vlib.core.obj.item.base.ItemProps;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import com.valkyrieofnight.vlib.integration.forge.fluid.FlowingFluidProps;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;

public class FluidCreator {
    private VLFlowingFluid source;
    private VLFlowingFluid flowing;
    private BucketItem bucket;
    private VLFlowingFluidBlock block;
    private boolean enableBucket;

    public FluidCreator(String modid, String fluid, FluidInstanceProps fluidProps, boolean enableBucket, ItemGroup group, String stillTexture, String flowingTexturte, int color) {
        this.enableBucket = enableBucket;
        FluidAttributes.Builder attributes = FluidAttributes.builder((ResourceLocation)new VLID(modid + ":" + stillTexture), (ResourceLocation)new VLID(modid + ":" + flowingTexturte)).color(color);
        FlowingFluidProps props = new FlowingFluidProps(Material.field_151586_h);
        props.doesNotBlockMovement().strength(fluidProps.explosionResistance);
        props.setCanSourcesMultiply(fluidProps.canSourcesMultiply).setSlopeFindDistance(fluidProps.slopeFindDistance).setLevelsDecreasedPerBlock(fluidProps.levelsDecreasedPerBlock).setTickRate(fluidProps.tickRate).setExplosionResistance(fluidProps.explosionResistance);
        this.source = new VLFlowingFluid.Source(new VLID(modid + ":" + fluid), props, attributes);
        this.flowing = new VLFlowingFluid.Flowing(new VLID(modid + ":flowing_" + fluid), props, attributes);
        this.source = this.source.setSourceFluid(this.source).setFlowingFluid(this.flowing);
        this.flowing = this.flowing.setSourceFluid(this.source).setFlowingFluid(this.flowing);
        if (enableBucket) {
            this.bucket = new BucketItem(this::getSource, new ItemProps().craftRemainder(Items.field_151133_ar).maxStackSize(1).tab(group).getItemProperties());
            this.bucket.setRegistryName((ResourceLocation)new VLID(modid + ":" + fluid + "_bucket"));
        }
        this.block = new VLFlowingFluidBlock(this::getSource, new VLID(modid + ":" + fluid + "_block"), new BlockProps(Material.field_151586_h).doesNotBlockMovement().strength(fluidProps.explosionResistance).noDrops());
        this.source.setBlockFluid(this.block).setBucketFluid(this.bucket);
        this.flowing.setBlockFluid(this.block).setBucketFluid(this.bucket);
    }

    public VLFlowingFluid getSource() {
        return this.source;
    }

    public VLFlowingFluid getFlowing() {
        return this.flowing;
    }

    public BucketItem getBucket() {
        return this.bucket;
    }

    public VLFlowingFluidBlock getBlock() {
        return this.block;
    }

    public void register(VLRegistry registry) {
        registry.registerFluid((Fluid)this.source);
        registry.registerFluid((Fluid)this.flowing);
        registry.registerBlock((Block)this.block);
        if (this.enableBucket) {
            registry.registerItem((Item)this.bucket);
        }
    }

    public static class FluidInstanceProps {
        protected boolean canSourcesMultiply = false;
        protected int slopeFindDistance = 4;
        protected int levelsDecreasedPerBlock = 1;
        protected int tickRate = 5;
        protected float explosionResistance = 100.0f;

        public FluidInstanceProps setCanSourcesMultiply(boolean opt) {
            this.canSourcesMultiply = opt;
            return this;
        }

        public FluidInstanceProps setSlopeFindDistance(int sfd) {
            this.slopeFindDistance = sfd;
            return this;
        }

        public FluidInstanceProps setLevelsDecreasedPerBlock(int levels) {
            this.levelsDecreasedPerBlock = levels;
            return this;
        }

        public FluidInstanceProps setTickRate(int tickRate) {
            this.tickRate = tickRate;
            return this;
        }

        public FluidInstanceProps setExplosionResistance(float resistance) {
            this.explosionResistance = resistance;
            return this;
        }
    }
}

