/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.generic;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public class GenericJsonSerializer<TYPE> {
    protected Gson gson;
    protected File file;
    protected TYPE data;
    protected Class<TYPE> typeClass;

    public GenericJsonSerializer(Gson gson, File file, Class<TYPE> typeClass) {
        this.gson = gson;
        this.file = file;
        this.typeClass = typeClass;
    }

    public void saveToJson() {
        try {
            this.file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.file);
            writer.write(this.gson.toJson(this.data));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromJson() {
        Object data = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            if (reader.ready()) {
                data = this.gson.fromJson((Reader)reader, this.typeClass);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data = data;
    }

    public TYPE getData() {
        return this.data;
    }
}

