/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib._mod.supporters.registry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib._mod.supporters.cape.CapeType;
import com.valkyrieofnight.vlib._mod.supporters.cape.CapeTypeRegistry;
import com.valkyrieofnight.vlib._mod.supporters.registry.SupporterRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class JsonSupporterRegistry {
    private static String ONLINE_CAPE_REGISTRY = "https://raw.githubusercontent.com/ValkyrieofNight/ValkyrieLib/ValkyrieofNight-supporters/supporters.json";
    private static String CACHE_LOCAL = "valkyrielib/cache/";
    protected final Gson gson;
    protected final File fileLocal = new File(CACHE_LOCAL + "supporters.json");
    protected volatile CopyOnWriteArrayList<Supporter> data;
    protected final SupporterRegistry registry;

    public JsonSupporterRegistry(SupporterRegistry reg) {
        this.registry = reg;
        this.gson = new GsonBuilder().create();
    }

    public void loadRegistryData() {
        if (!this.download()) {
            if (!this.loadCached()) {
                this.loadBuiltin();
            }
        } else {
            this.saveToFile();
        }
        for (Supporter supporter : this.data) {
            if (supporter == null || !supporter.isValid()) continue;
            UUID id = supporter.getUUID();
            CapeType ct = supporter.getCapeType();
            if (id == null || ct == null) continue;
            this.registry.register(id, ct);
        }
    }

    private boolean download() {
        try {
            URL urlOnline = new URL(ONLINE_CAPE_REGISTRY);
            BufferedReader br = new BufferedReader(new InputStreamReader(urlOnline.openStream()));
            this.data = this.loadFromBufferedReader(br);
            br.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void saveToFile() {
        try {
            this.fileLocal.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(this.fileLocal);
            fw.write(this.gson.toJson(this.data));
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadCached() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.fileLocal));
            this.data = this.loadFromBufferedReader(br);
            br.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void loadBuiltin() {
        this.data = Lists.newCopyOnWriteArrayList();
    }

    private CopyOnWriteArrayList<Supporter> loadFromBufferedReader(BufferedReader br) throws IOException {
        CopyOnWriteArrayList bl = null;
        if (br.ready()) {
            Type typeOf = new TypeToken<CopyOnWriteArrayList<Supporter>>(){}.getType();
            bl = (CopyOnWriteArrayList)this.gson.fromJson((Reader)br, typeOf);
        }
        return bl;
    }

    public static class Supporter {
        public String u;
        public String t;

        public boolean isValid() {
            if (this.getUUID() == null) {
                return false;
            }
            return this.getCapeType() != CapeType.NONE;
        }

        public UUID getUUID() {
            try {
                UUID t = UUID.fromString(this.u);
                return t;
            }
            catch (Exception e) {
                return null;
            }
        }

        public CapeType getCapeType() {
            return CapeTypeRegistry.getInstance().getCape(this.t);
        }
    }
}

