/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.z_test_environment;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.item.ItemStack;

public class TestParser {
    protected Gson gson;
    protected File file;
    protected Data data;
    DataParser parser = new DataParser();

    public TestParser(String file) {
        this.gson = JsonUtils.createTypedGsonBuilder(ProviderDeserializerRegistry.getInstance().getAllAsArray()).registerTypeAdapter(this.parser.getType(), (Object)this.parser).create();
        this.file = new File(file);
    }

    public void deserialize() {
        Data data = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            if (br.ready()) {
                data = (Data)this.gson.fromJson((Reader)br, Data.class);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.data = data;
    }

    public Data getData() {
        return this.data;
    }

    public static class DataParser
    implements ITypedDeserializer<Data> {
        private TypeToken<Data> token = TypeToken.get(Data.class);

        @Override
        public TypeToken<Data> getTypeToken() {
            return this.token;
        }

        @Override
        public String getTypeIdentifier() {
            return "test_recipe";
        }

        public Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jo;
            JsonArray ja;
            Data ret = new Data();
            if (json.isJsonObject() && (ja = JsonUtils.getAsArray((jo = (JsonObject)json).get("items"))) != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    JsonObject joi = JsonUtils.getAsJsonObject(ja.get(i));
                    try {
                        Provider is;
                        String dt;
                        Type t = DeserializerUtils.getDeserializerTypeFromObject(joi);
                        String string = dt = t != null ? ProviderDeserializerRegistry.getInstance().getDataReturnType(t) : null;
                        if (StringUtils.isNullOrEmpty(dt) || !dt.equals("itemstack") || (is = (Provider)context.deserialize((JsonElement)joi, t)) == null) continue;
                        ret.items.add(is);
                        continue;
                    }
                    catch (Exception e) {
                        throw new JsonParseException((Throwable)e);
                    }
                }
            }
            return ret;
        }
    }

    public static class Data {
        public List<Provider<ItemStack>> items = Lists.newArrayList();

        public String toString() {
            String data = "Size(" + this.items.size() + ") Data: ";
            for (Provider<ItemStack> ip : this.items) {
                data = data + ip.request(null).toString() + " ";
            }
            return data;
        }
    }
}

