/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.value;

import com.valkyrieofnight.vlib.core.obj.base.IProvideID;
import com.valkyrieofnight.vlib.core.util.obj.TagUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.value.RawValueProviderDeserializers;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class RawValueProvider<RETURN_TYPE>
extends Provider<RETURN_TYPE> {
    protected RETURN_TYPE data;

    public RawValueProvider(RETURN_TYPE data) {
        this.data = data;
    }

    public RawValueProvider(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public RETURN_TYPE request(ConditionContainerProvider dataContainer) {
        return this.data;
    }

    public static class FluidStack
    extends RawValueProvider<net.minecraftforge.fluids.FluidStack> {
        public FluidStack(net.minecraftforge.fluids.FluidStack data) {
            super(data);
        }

        public FluidStack(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.FLUIDSTACK.getTypeIdentifier());
            buffer.writeFluidStack((net.minecraftforge.fluids.FluidStack)this.data);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readFluidStack();
        }
    }

    public static class ItemStack
    extends RawValueProvider<net.minecraft.item.ItemStack> {
        public ItemStack(net.minecraft.item.ItemStack data) {
            super(data);
        }

        public ItemStack(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.ITEMSTACK.getTypeIdentifier());
            buffer.func_150788_a((net.minecraft.item.ItemStack)this.data);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.func_150791_c();
        }
    }

    public static class FluidTag
    extends RawValueProvider<ITag<net.minecraft.fluid.Fluid>>
    implements IProvideID {
        private VLID tag;

        public FluidTag(VLID data) {
            super(TagUtils.getFluidTag(data));
            this.tag = data;
        }

        public FluidTag(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.FLUID_TAG.getTypeIdentifier());
            buffer.func_192572_a((ResourceLocation)this.tag);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.tag = VLID.from(buffer.func_192575_l());
        }

        @Override
        public boolean isValid() {
            ITag<net.minecraft.fluid.Fluid> t = this.getTag();
            return t != null && !t.func_230236_b_().isEmpty();
        }

        @Override
        public ITag<net.minecraft.fluid.Fluid> request(ConditionContainerProvider dataContainer) {
            return this.getTag();
        }

        private ITag<net.minecraft.fluid.Fluid> getTag() {
            return TagUtils.getFluidTag(this.tag);
        }

        @Override
        public VLID getID() {
            return this.tag;
        }
    }

    public static class BlockTag
    extends RawValueProvider<ITag<Block>>
    implements IProvideID {
        private VLID tag;

        public BlockTag(VLID data) {
            super(TagUtils.getBlockTag(data));
            this.tag = data;
        }

        public BlockTag(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.BLOCK_TAG.getTypeIdentifier());
            buffer.func_192572_a((ResourceLocation)this.tag);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.tag = VLID.from(buffer.func_192575_l());
        }

        @Override
        public boolean isValid() {
            ITag<Block> t = this.getTag();
            return t != null && !t.func_230236_b_().isEmpty();
        }

        @Override
        public ITag<Block> request(ConditionContainerProvider dataContainer) {
            return this.getTag();
        }

        private ITag<Block> getTag() {
            return TagUtils.getBlockTag(this.tag);
        }

        @Override
        public VLID getID() {
            return this.tag;
        }
    }

    public static class ItemTag
    extends RawValueProvider<ITag<net.minecraft.item.Item>>
    implements IProvideID {
        private VLID tag;

        public ItemTag(VLID data) {
            super(TagUtils.getItemTag(data));
            this.tag = data;
        }

        public ItemTag(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.ITEM_TAG.getTypeIdentifier());
            buffer.func_192572_a((ResourceLocation)this.tag);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.tag = VLID.from(buffer.func_192575_l());
        }

        @Override
        public boolean isValid() {
            ITag<net.minecraft.item.Item> t = this.getTag();
            return t != null && !t.func_230236_b_().isEmpty();
        }

        @Override
        public ITag<net.minecraft.item.Item> request(ConditionContainerProvider dataContainer) {
            return this.getTag();
        }

        private ITag<net.minecraft.item.Item> getTag() {
            return TagUtils.getItemTag(this.tag);
        }

        @Override
        public VLID getID() {
            return this.tag;
        }
    }

    public static class CompoundNBT
    extends RawValueProvider<net.minecraft.nbt.CompoundNBT> {
        public CompoundNBT(net.minecraft.nbt.CompoundNBT data) {
            super(data);
        }

        public CompoundNBT(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.COMPOUND_NBT.getTypeIdentifier());
            buffer.func_150786_a((net.minecraft.nbt.CompoundNBT)this.data);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.func_150793_b();
        }
    }

    public static class Fluid
    extends RawValueProvider<net.minecraft.fluid.Fluid> {
        public Fluid(net.minecraft.fluid.Fluid data) {
            super(data);
        }

        public Fluid(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.FLUID.getTypeIdentifier());
            buffer.writeFluidStack(new net.minecraftforge.fluids.FluidStack((net.minecraft.fluid.Fluid)this.data, 1));
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readFluidStack().getFluid();
        }
    }

    public static class Item
    extends RawValueProvider<net.minecraft.item.Item> {
        public Item(net.minecraft.item.Item data) {
            super(data);
        }

        public Item(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.ITEM.getTypeIdentifier());
            buffer.func_150788_a(new net.minecraft.item.ItemStack((IItemProvider)this.data));
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.func_150791_c().func_77973_b();
        }
    }

    public static class String
    extends RawValueProvider<java.lang.String> {
        public String(java.lang.String data) {
            super(data);
        }

        public String(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.STRING.getTypeIdentifier());
            buffer.func_180714_a((java.lang.String)this.data);
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.func_218666_n();
        }
    }

    public static class Char
    extends RawValueProvider<Character> {
        public Char(Character data) {
            super(data);
        }

        public Char(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.CHAR.getTypeIdentifier());
            buffer.writeChar((int)((Character)this.data).charValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = Character.valueOf(buffer.readChar());
        }
    }

    public static class Double
    extends RawValueProvider<java.lang.Double> {
        public Double(java.lang.Double data) {
            super(data);
        }

        public Double(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.DOUBLE.getTypeIdentifier());
            buffer.writeDouble(((java.lang.Double)this.data).doubleValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readDouble();
        }
    }

    public static class Float
    extends RawValueProvider<java.lang.Float> {
        public Float(java.lang.Float data) {
            super(data);
        }

        public Float(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.FLOAT.getTypeIdentifier());
            buffer.writeFloat(((java.lang.Float)this.data).floatValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = java.lang.Float.valueOf(buffer.readFloat());
        }
    }

    public static class Long
    extends RawValueProvider<java.lang.Long> {
        public Long(java.lang.Long data) {
            super(data);
        }

        public Long(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.LONG.getTypeIdentifier());
            buffer.writeLong(((java.lang.Long)this.data).longValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readLong();
        }
    }

    public static class Short
    extends RawValueProvider<java.lang.Short> {
        public Short(java.lang.Short data) {
            super(data);
        }

        public Short(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.SHORT.getTypeIdentifier());
            buffer.writeShort((int)((java.lang.Short)this.data).shortValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readShort();
        }
    }

    public static class Int
    extends RawValueProvider<Integer> {
        public Int(Integer data) {
            super(data);
        }

        public Int(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.INT.getTypeIdentifier());
            buffer.writeInt(((Integer)this.data).intValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readInt();
        }
    }

    public static class Byte
    extends RawValueProvider<java.lang.Byte> {
        public Byte(java.lang.Byte data) {
            super(data);
        }

        public Byte(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.BYTE.getTypeIdentifier());
            buffer.writeByte((int)((java.lang.Byte)this.data).byteValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readByte();
        }
    }

    public static class Boolean
    extends RawValueProvider<java.lang.Boolean> {
        public Boolean(java.lang.Boolean data) {
            super(data);
        }

        public Boolean(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(RawValueProviderDeserializers.BOOLEAN.getTypeIdentifier());
            buffer.writeBoolean(((java.lang.Boolean)this.data).booleanValue());
        }

        @Override
        public void readPacketData(PacketBuffer buffer) {
            this.data = buffer.readBoolean();
        }
    }
}

