/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.bu;

import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import net.minecraft.network.PacketBuffer;

public abstract class TagIngrediant<VALUE>
extends Ingredient<VALUE> {
    protected Ingredient.TagIngredientType selector;
    protected String namespace = null;

    public TagIngrediant(Ingredient.TagIngredientType selector) {
        this.selector = selector;
    }

    public TagIngrediant(Ingredient.TagIngredientType selector, String namespace) {
        this.selector = selector;
        this.namespace = namespace;
        if (StringUtils.isNullOrEmpty(this.namespace)) {
            this.namespace = "minecraft";
        }
    }

    public TagIngrediant(PacketBuffer packetBuffer) {
        super(packetBuffer);
    }

    @Override
    public final void writePacketData(PacketBuffer buffer) {
        this.writeOtherPacketData(buffer);
        buffer.writeInt(this.selector.ordinal());
        buffer.writeBoolean(this.namespace != null);
        if (this.namespace != null) {
            buffer.func_180714_a(this.namespace);
        }
    }

    @Override
    public final void readPacketData(PacketBuffer buffer) {
        this.readOtherPacketData(buffer);
        this.selector = Ingredient.TagIngredientType.getFromOrdinal(buffer.readInt());
        if (buffer.readBoolean()) {
            this.namespace = buffer.func_218666_n();
        }
    }

    public final Ingredient.TagIngredientType getSelector() {
        return this.selector;
    }

    public abstract int getTotalTagEntries();

    protected abstract void writeOtherPacketData(PacketBuffer var1);

    protected abstract void readOtherPacketData(PacketBuffer var1);
}

