/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.block;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;

public class BlockProviderIngredient
extends Ingredient<Block> {
    private Provider<Block> provider;

    public BlockProviderIngredient(@NotNull Provider<Block> blockProvider) {
        this.provider = blockProvider;
    }

    public BlockProviderIngredient(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(BlockProviderIngredient.getFromClass(this.getClass()));
        DeserializerUtils.writeProviderToPacket(this.provider, buffer);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.provider = DeserializerUtils.readProviderFromPacket(buffer);
    }

    @Override
    public boolean test(ConditionContainerProvider provider, Block test) {
        return test != null && this.provider.request(provider).equals(test.getBlock());
    }

    @Override
    public List<Block> request(ConditionContainerProvider ccp) {
        return Collections.singletonList(this.provider.request(ccp));
    }

    @Override
    public int requestAmount(ConditionContainerProvider provider) {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.provider.isValid();
    }
}

