/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient;

import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import net.minecraft.network.PacketBuffer;

public abstract class TagIngredient<VALUE>
extends Ingredient<VALUE> {
    protected Ingredient.TagIngredientType selector;
    protected String[] properties = new String[0];

    public TagIngredient(@NotNull Ingredient.TagIngredientType selector) {
        this.selector = selector;
    }

    public TagIngredient(@NotNull Ingredient.TagIngredientType selector, @NotNull String namespace) {
        this.selector = selector;
        this.properties = new String[]{namespace};
        if (StringUtils.isNullOrEmpty(namespace)) {
            this.properties = new String[]{"minecraft"};
        }
    }

    public TagIngredient(@NotNull Ingredient.TagIngredientType selector, @NotNull String[] properties) {
        this.selector = selector;
        this.properties = properties;
        if (this.properties == null) {
            throw new NullPointerException("Selector values cannot be null");
        }
    }

    public TagIngredient(PacketBuffer packetBuffer) {
        super(packetBuffer);
    }

    @Override
    public final void writePacketData(PacketBuffer buffer) {
        this.writeOtherPacketData(buffer);
        buffer.writeInt(this.selector.ordinal());
        buffer.writeInt(this.properties.length);
        for (String s : this.properties) {
            buffer.func_180714_a(s);
        }
    }

    @Override
    public final void readPacketData(PacketBuffer buffer) {
        this.readOtherPacketData(buffer);
        this.selector = Ingredient.TagIngredientType.getFromOrdinal(buffer.readInt());
        int propCount = buffer.readInt();
        String[] props = new String[propCount];
        for (int i = 0; i < propCount; ++i) {
            props[i] = buffer.func_218666_n();
        }
    }

    public final Ingredient.TagIngredientType getSelector() {
        return this.selector;
    }

    public abstract int getTotalTagEntries();

    protected abstract void writeOtherPacketData(PacketBuffer var1);

    protected abstract void readOtherPacketData(PacketBuffer var1);
}

