/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.autoutil;

import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.WorldUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.autoutil.AbstractAuto;
import com.valkyrieofnight.vlib.multiblock.obj.tile.FakeTile;
import com.valkyrieofnight.vlib.multiblock.obj.tile.IController;
import com.valkyrieofnight.vlib.multiblock.obj.tile.ISlave;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AutoDestructor<TILE extends TileEntity>
extends AbstractAuto<TILE> {
    private boolean breakOtherTiles = false;

    public AutoDestructor(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed, boolean breakOtherTiles) {
        super(world, controller, player, orientation, speed);
        this.breakOtherTiles = breakOtherTiles;
    }

    public AutoDestructor(ServerWorld world, TILE controller, PlayerEntity player, XYZOrientation orientation, int speed, boolean breakOtherTiles, Action finishedAction) {
        super(world, controller, player, orientation, speed, finishedAction);
        this.breakOtherTiles = breakOtherTiles;
    }

    @Override
    protected void onFinished() {
        this.player.func_146105_b((ITextComponent)new TranslationTextComponent("status.valkyrielib.destructor.finished").func_230530_a_(StyleUtil.create(Color4.RED)), false);
    }

    @Override
    protected boolean doWork(AbstractAuto.CompPos cp) {
        BlockPos pos = cp.offset;
        BlockState bs = this.world.func_180495_p(pos);
        boolean canBreak = false;
        if (!bs.hasTileEntity() && bs.func_185887_b((IBlockReader)this.world, pos) >= 0.0f) {
            canBreak = true;
        } else {
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof FakeTile) {
                canBreak = true;
            } else if (te instanceof ISlave) {
                ISlave slave = (ISlave)te;
                if (slave.hasController()) {
                    if (this.samePosition(slave.getController(), ((IController)this.controller).getPosition())) {
                        canBreak = true;
                    }
                } else {
                    canBreak = true;
                }
            } else if (this.breakOtherTiles) {
                canBreak = true;
            }
        }
        if (canBreak) {
            WorldUtils.harvestBlockAndPickup((World)this.world, pos, this.world.func_180495_p(pos), this.player);
        } else {
            this.player.func_146105_b((ITextComponent)new TranslationTextComponent("status.valkyrielib.destructor.cannot_break").func_230529_a_((ITextComponent)new StringTextComponent("" + cp.offset)), false);
        }
        return true;
    }

    private boolean samePosition(BlockPos one, BlockPos two) {
        if (one.func_177958_n() != two.func_177958_n()) {
            return false;
        }
        if (one.func_177956_o() != two.func_177956_o()) {
            return false;
        }
        return one.func_177952_p() == two.func_177952_p();
    }
}

