/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modloader.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.obj.block.base.color.BlockColor;
import com.valkyrieofnight.vlib.core.obj.item.base.color.ItemColor;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.modloader.events.ForgeRegEvents;
import com.valkyrieofnight.vlib.module.registry.IMCRegistryClient;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ForgeRegEventsClient
extends ForgeRegEvents
implements IMCRegistryClient {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public volatile List<Block> coloredBlocks = Lists.newCopyOnWriteArrayList();
    public volatile List<Item> coloredItems = Lists.newCopyOnWriteArrayList();
    public volatile Map<Block, Predicate<RenderType>> blockRenderTypes = Maps.newConcurrentMap();
    public volatile Map<Fluid, Predicate<RenderType>> fluidRenderTypes = Maps.newConcurrentMap();

    @Override
    @SubscribeEvent
    public void eBlock(RegistryEvent.Register<Block> e) {
        super.eBlock(e);
        for (Block b : this.blockRenderTypes.keySet()) {
            RenderTypeLookup.setRenderLayer((Block)b, this.blockRenderTypes.get(b));
        }
    }

    @Override
    @SubscribeEvent
    public void eFluid(RegistryEvent.Register<Fluid> e) {
        super.eFluid(e);
        for (Fluid f : this.fluidRenderTypes.keySet()) {
            RenderTypeLookup.setRenderLayer((Fluid)f, this.fluidRenderTypes.get(f));
        }
    }

    @SubscribeEvent
    public void eRegClient(FMLClientSetupEvent event) {
        BlockColors bc = mc.func_184125_al();
        ItemColors ic = mc.getItemColors();
        for (Block blk : this.coloredBlocks) {
            bc.func_186722_a((IBlockColor)new BlockColor(), new Block[]{blk});
        }
        for (Item itm : this.coloredItems) {
            ic.func_199877_a((IItemColor)new ItemColor(), new IItemProvider[]{itm});
        }
    }

    @Override
    public void registerBlockColor(@NotNull Block block) {
        this.coloredBlocks.add(block);
    }

    @Override
    public void registerItemColor(@NotNull Item item) {
        this.coloredItems.add(item);
    }

    @Override
    public void setRenderType(Block block, Predicate<RenderType> predicate) {
        this.blockRenderTypes.put(block, predicate);
    }

    @Override
    public void setRenderType(Fluid fluid, Predicate<RenderType> predicate) {
        this.fluidRenderTypes.put(fluid, predicate);
    }
}

