/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier.attribute.impl;

import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public abstract class FloatIntMultiplierAttribute
extends Attribute<Float, Integer> {
    public FloatIntMultiplierAttribute(AttributeID id, Float defaultValue) {
        super(id, defaultValue);
    }

    @Override
    public Float getFinalized(List<Float> all) {
        float total = 0.0f;
        for (Float f : all) {
            total += f.floatValue();
        }
        return Float.valueOf(total);
    }

    @Override
    public Integer getModifiedValue(AbstractModifierHandler modifierHandler, Integer unmodifiedValue) {
        return (int)((float)unmodifiedValue.intValue() * this.getMultiplier(((Float)modifierHandler.getAttributeFinazliedValueOrDefault(this.getID(), this.defaultValue)).floatValue()));
    }

    @Override
    public Float readFromNBT(CompoundNBT nbt) {
        String id = this.getID().toString();
        if (nbt.func_74764_b(id)) {
            return Float.valueOf(nbt.func_74760_g(id));
        }
        return (Float)this.defaultValue;
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt, Float data) {
        nbt.func_74776_a(this.getID().toString(), data.floatValue());
        return nbt;
    }

    protected abstract float getMultiplier(float var1);
}

