/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;

public abstract class AbstractModifierHandler
implements INBTSerializer {
    protected List<Attribute> scannable = Lists.newArrayList();
    protected Map<AttributeID, Object> finalizedValues = Maps.newHashMap();

    public void addScannable(AttributeID id) {
        if (!AttributeRegistry.getInstance().hasAttribute(id)) {
            return;
        }
        this.scannable.add(AttributeRegistry.getInstance().getByID(id));
    }

    public Object getAttributeFinazliedValueOrDefault(AttributeID id, Object defValue) {
        if (!this.finalizedValues.containsKey(id)) {
            return defValue;
        }
        return this.finalizedValues.get(id);
    }

    public String toString() {
        return "AbstractModifierHandler{scannable=" + this.scannable + ", finalizedValues=" + this.finalizedValues + '}';
    }

    public abstract void scanAttributes();

    public boolean hasScannedAttribute(AttributeID id) {
        return this.finalizedValues.containsKey(id);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (Attribute atr : this.scannable) {
            if (!this.hasScannedAttribute(atr.getID())) continue;
            atr.writeToNBT(nbt, this.finalizedValues.get(atr.getID()));
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        for (Attribute atr : this.scannable) {
            if (!atr.hasAttribute(nbt)) continue;
            this.finalizedValues.put(atr.getID(), atr.readFromNBT(nbt));
        }
    }
}

