/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.fluid;

import com.valkyrieofnight.vlib.core.obj.fluid.base.IVLFluid;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.integration.forge.block.VLFlowingFluidForgeBlock;
import com.valkyrieofnight.vlib.integration.forge.fluid.FlowingFluidProps;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class VLFlowingFluidForge
extends ForgeFlowingFluid
implements IVLFluid {
    protected VLID id;
    private final FlowingFluidProps fluidProps;
    private final FluidAttributes.Builder fluidAttributes;
    private VLFlowingFluidForge flowingFluid;
    private VLFlowingFluidForge sourceFluid;
    private BucketItem bucketFluid;
    private VLFlowingFluidForgeBlock blockFluid;

    public VLFlowingFluidForge(VLID id, FlowingFluidProps fluidProps, FluidAttributes.Builder fluidAttributes) {
        super(fluidProps.getForgeFlowingProperties(fluidAttributes));
        fluidProps.setProviders(() -> this.sourceFluid, () -> this.flowingFluid);
        this.id = id;
        this.fluidProps = fluidProps;
        this.fluidAttributes = fluidAttributes;
        this.setRegistryName(id);
    }

    protected FluidAttributes createAttributes() {
        return this.fluidAttributes.build((Fluid)this);
    }

    protected void func_205580_a(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().hasTileEntity(state) ? worldIn.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)worldIn, (BlockPos)pos, (TileEntity)tileentity);
    }

    protected boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !p_215665_4_.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    @Override
    public VLID getID() {
        return this.id;
    }

    public VLFlowingFluidForge getFlowing() {
        return this.flowingFluid;
    }

    public VLFlowingFluidForge getSource() {
        return this.sourceFluid;
    }

    protected boolean func_205579_d() {
        return this.fluidProps.canSourcesMultiply();
    }

    public int func_185698_b(IWorldReader p_185698_1_) {
        return this.fluidProps.getSlopeFindDistance();
    }

    public int func_204528_b(IWorldReader p_204528_1_) {
        return this.fluidProps.getLevelsDecreasedPerBlock();
    }

    public Item func_204524_b() {
        return this.bucketFluid != null ? this.bucketFluid : Items.field_190931_a;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return this.fluidProps.getTickRate();
    }

    protected float func_210195_d() {
        return this.fluidProps.getExplosionResistance();
    }

    protected BlockState func_204527_a(FluidState state) {
        return (BlockState)this.blockFluid.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(VLFlowingFluidForge.func_207205_e((FluidState)state)));
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this.sourceFluid || fluidIn == this.flowingFluid;
    }

    @NotNull
    public VLFlowingFluidForge setFlowingFluid(VLFlowingFluidForge flowingFluid) {
        this.flowingFluid = flowingFluid;
        return this;
    }

    @NotNull
    public VLFlowingFluidForge setSourceFluid(VLFlowingFluidForge sourceFluid) {
        this.sourceFluid = sourceFluid;
        return this;
    }

    @NotNull
    public VLFlowingFluidForge setBucketFluid(BucketItem bucketFluid) {
        this.bucketFluid = bucketFluid;
        return this;
    }

    public VLFlowingFluidForge setBlockFluid(VLFlowingFluidForgeBlock blockFluid) {
        this.blockFluid = blockFluid;
        return this;
    }

    public static class Flowing
    extends VLFlowingFluidForge {
        public Flowing(VLID id, FlowingFluidProps fluidProps, FluidAttributes.Builder fluidAttributes) {
            super(id, fluidProps, fluidAttributes);
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }

        public int func_207192_d(@NotNull FluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }
    }

    public static class Source
    extends VLFlowingFluidForge {
        public Source(VLID id, FlowingFluidProps fluidProps, FluidAttributes.Builder fluidAttributes) {
            super(id, fluidProps, fluidAttributes);
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }

        public int func_207192_d(FluidState p_207192_1_) {
            return 8;
        }
    }
}

