/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.wrapped;

import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorProviderBlock;
import com.valkyrieofnight.vlib.core.obj.item.base.color.IColorProviderItem;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import com.valkyrieofnight.vlib.modloader.events.ForgeRegEventsClient;
import com.valkyrieofnight.vlib.module.registry.IMCRegistryClient;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class VLRegistryClient
extends VLRegistry
implements IMCRegistryClient {
    protected final ThemeRegistryClient THEME_REGISTRY;
    protected final IMCRegistryClient REG_CLIENT;

    public VLRegistryClient(ThemeRegistryClient reg) {
        super(new ForgeRegEventsClient());
        this.THEME_REGISTRY = reg;
        this.REG_CLIENT = (ForgeRegEventsClient)this.REG;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.REG);
    }

    public VLRegistryClient() {
        this(ThemeRegistryClient.getInstance());
    }

    public <M extends Container, U extends Screen> void registerScreenFactory(ContainerType<? extends M> containerType, ScreenManager.IScreenFactory<M, U> screenFactory) {
        ScreenManager.func_216911_a(containerType, screenFactory);
    }

    public void registerTexture(ThemeID themeID, AssetID id, GuiTexture texture) {
        this.THEME_REGISTRY.registerTexture(themeID, id, texture);
    }

    public void registerColor(ThemeID themeID, AssetID id, Color4 color4) {
        this.THEME_REGISTRY.registerColor(themeID, id, color4);
    }

    public void registerSizableBox(ThemeID themeID, AssetID id, GuiSizableBox box) {
        this.THEME_REGISTRY.registerSizableBox(themeID, id, box);
    }

    @Override
    public void registerBlockColor(Block blk) {
        if (blk == null) {
            return;
        }
        this.REG_CLIENT.registerBlockColor(blk);
    }

    @Override
    public void registerItemColor(Item itm) {
        if (itm == null) {
            return;
        }
        this.REG_CLIENT.registerItemColor(itm);
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        super.registerBlock(block);
        if (block instanceof IColorProviderBlock) {
            this.registerBlockColor(block);
        }
    }

    @Override
    public void registerItem(@NotNull Item item) {
        super.registerItem(item);
        if (item instanceof IColorProviderItem) {
            this.registerItemColor(item);
        }
    }

    @Override
    public ThemeRegistry getThemeRegistry() {
        return this.THEME_REGISTRY;
    }

    public void setRenderType(Block block, RenderType type) {
        this.REG_CLIENT.setRenderType(block, arg_0 -> ((RenderType)type).equals(arg_0));
    }

    public void setRenderType(Fluid fluid, RenderType type) {
        this.REG_CLIENT.setRenderType(fluid, arg_0 -> ((RenderType)type).equals(arg_0));
    }

    @Override
    public void setRenderType(Block block, Predicate<RenderType> predicate) {
        this.REG_CLIENT.setRenderType(block, predicate);
    }

    @Override
    public void setRenderType(Fluid fluid, Predicate<RenderType> predicate) {
        this.REG_CLIENT.setRenderType(fluid, predicate);
    }
}

