/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static <T> T getClassInstance(String className, Class<T> expected) {
        try {
            Class<?> cls = Class.forName(className);
            if (!expected.isAssignableFrom(expected)) {
                throw new RuntimeException("Class '" + className + "' is nott a " + expected.getSimpleName());
            }
            return (T)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find " + expected.getSimpleName() + ": " + className);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not instantiate " + expected.getSimpleName() + ": " + className);
        }
    }

    public static List<Class> loadClassesFromJar(String jarPath) throws IOException {
        ArrayList classes = Lists.newArrayList();
        JarFile jar = new JarFile(jarPath);
        Enumeration<JarEntry> e = jar.entries();
        URL[] urls = new URL[]{new URL("jar:file:" + jarPath + "!/")};
        URLClassLoader cl = URLClassLoader.newInstance(urls);
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
            String className = je.getName().substring(0, je.getName().length() - 6);
            className = className.replace('/', '.');
            try {
                classes.add(cl.loadClass(className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return classes;
    }

    public static List<Class> loadClassesFromPackage(String packagePath) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        assert (cl != null);
        String path = packagePath.replace(".", "/");
        Enumeration<URL> resources = cl.getResources(path);
        ArrayList dirs = Lists.newArrayList();
        while (resources.hasMoreElements()) {
            URL res = resources.nextElement();
            dirs.add(new File(res.getFile()));
        }
        ArrayList classes = Lists.newArrayList();
        for (File dir : dirs) {
            classes.addAll(ClassUtil.findClasses(dir, packagePath));
        }
        return classes;
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

