/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class ScrollBarElement
extends VLElement
implements IElementInput,
IElementDraw,
IElementUpdate,
IElementThemeListener {
    private int tabSizeX;
    private int tabSizeY;
    private boolean clickedOnSroll;
    private float scrollProgress = 0.0f;
    private AssetID scroll_nub;
    private AssetID scroll_nub_disabled;
    private GuiTexture texture;
    private GuiTexture texture_disabled;
    protected Alignment aligned;
    protected Provider<Integer> length;
    protected Provider<Integer> scrollDistance;
    protected Provider<Integer> stepAmount;
    protected Provider<Integer> scrollPosition;
    protected Action1a<Float> onScroll;

    public ScrollBarElement(String id, int tabSizeX, int tabSizeY, @NotNull AssetID scrollNub, @NotNull AssetID scrollNubDisabled, @NotNull Alignment aligned, @NotNull Provider<Integer> length, @NotNull Provider<Integer> distance, @NotNull Provider<Integer> position, @NotNull Provider<Integer> stepAmount) {
        super(id);
        this.scroll_nub = scrollNub;
        this.scroll_nub_disabled = scrollNubDisabled;
        this.aligned = aligned;
        this.length = length;
        this.scrollDistance = distance;
        this.scrollPosition = position;
        this.stepAmount = stepAmount;
        this.tabSizeX = tabSizeX;
        this.tabSizeY = tabSizeY;
        this.scrollProgress = 0.0f;
    }

    public ScrollBarElement(String id, int tabSizeX, int tabSizeY, @NotNull AssetID scrollNub, @NotNull AssetID scrollNubDisabled, @NotNull Alignment aligned, @NotNull Provider<Integer> length, @NotNull Provider<Integer> distance, @NotNull Provider<Integer> position, @NotNull Provider<Integer> stepAmount, @NotNull Action1a<Float> onScroll) {
        super(id);
        this.scroll_nub = scrollNub;
        this.scroll_nub_disabled = scrollNubDisabled;
        this.aligned = aligned;
        this.length = length;
        this.scrollDistance = distance;
        this.scrollPosition = position;
        this.stepAmount = stepAmount;
        this.onScroll = onScroll;
        this.tabSizeX = tabSizeX;
        this.tabSizeY = tabSizeY;
    }

    public void setOnScroll(Action1a<Float> onScroll) {
        this.onScroll = onScroll;
    }

    @Override
    public void load(CompoundNBT nbt) {
        if (nbt.func_74764_b("scroll")) {
            this.scrollProgress = nbt.func_74760_g("scroll");
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74776_a("scroll", this.scrollProgress);
        return nbt;
    }

    @Override
    public int getSizeX() {
        return this.aligned == Alignment.HORIZONTAL ? this.length.request() : this.tabSizeX;
    }

    @Override
    public int getSizeY() {
        return this.aligned == Alignment.VERTICAL ? this.length.request() : this.tabSizeY;
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean horizontal;
        this.clickedOnSroll = false;
        boolean bl = horizontal = this.aligned == Alignment.HORIZONTAL;
        if (this.aligned == Alignment.HORIZONTAL) {
            if (GuiUtils.withinBox(mouseX, mouseY, this.getActualX(), this.getActualY(), this.length.request().intValue(), this.texture.height)) {
                this.clickedOnSroll = true;
                return true;
            }
        } else if (GuiUtils.withinBox(mouseX, mouseY, this.getActualX(), this.getActualY(), this.texture.width, this.length.request().intValue())) {
            this.clickedOnSroll = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        if (this.clickedOnSroll && this.canScroll()) {
            boolean horizontal = this.aligned == Alignment.HORIZONTAL;
            double dragged = horizontal ? mouseX : mouseY;
            float boxSize = horizontal ? this.texture.width : this.texture.height;
            float halfBox = boxSize / 2.0f;
            int i = horizontal ? this.getActualX() : this.getActualY();
            int j = i + this.length.request();
            this.scrollProgress = ((float)dragged - (float)i - halfBox) / ((float)(j - i) - boxSize);
            this.scrollProgress = MathHelper.func_76131_a((float)this.scrollProgress, (float)0.0f, (float)1.0f);
            if (this.onScroll != null) {
                this.onScroll.execute(Float.valueOf(this.scrollProgress));
            }
            return true;
        }
        return false;
    }

    public float getScrollProgress() {
        return this.scrollProgress;
    }

    private boolean canScroll() {
        return this.scrollDistance.request() != 0;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        if (this.canScroll()) {
            this.scrollProgress = (float)((double)this.scrollProgress + (double)((float)this.stepAmount.request().intValue() / (float)this.scrollDistance.request().intValue()) * -scrolled);
            this.scrollProgress = MathHelper.func_76131_a((float)this.scrollProgress, (float)0.0f, (float)1.0f);
            if (this.onScroll != null) {
                this.onScroll.execute(Float.valueOf(this.scrollProgress));
            }
        }
        return false;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        int x = this.getActualX();
        int y = this.getActualY();
        if (this.scrollDistance.request() == 0) {
            if (this.aligned == Alignment.HORIZONTAL) {
                x = (int)((float)this.getActualX() + ((float)this.length.request().intValue() - (float)this.texture_disabled.width) * this.scrollProgress);
            } else {
                y = (int)((float)this.getActualY() + ((float)this.length.request().intValue() - (float)this.texture_disabled.height) * this.scrollProgress);
            }
            GuiUtils.drawGuiTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.texture_disabled, x, y, this.texture_disabled.width, this.texture_disabled.height);
        } else {
            if (this.aligned == Alignment.HORIZONTAL) {
                x = (int)((float)this.getActualX() + ((float)this.length.request().intValue() - (float)this.texture.width) * this.scrollProgress);
            } else {
                y = (int)((float)this.getActualY() + ((float)this.length.request().intValue() - (float)this.texture.height) * this.scrollProgress);
            }
            GuiUtils.drawGuiTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.texture, x, y, this.texture.width, this.texture.height);
        }
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public void update() {
        if (!this.clickedOnSroll) {
            float scroll = this.scrollPosition.request().intValue();
            this.scrollProgress = scroll != 0.0f ? scroll / (float)this.scrollDistance.request().intValue() : 0.0f;
        }
        if (this.scrollDistance.request() == 0) {
            this.scrollProgress = 0.0f;
        }
        this.scrollProgress = MathUtil.clamp(this.scrollProgress, 0.0f, 1.0f);
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.texture = current.getTexture(this.scroll_nub);
        this.texture_disabled = current.getTexture(this.scroll_nub_disabled);
    }

    @Override
    public boolean livesOutsideContainer() {
        return true;
    }
}

