/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.guage;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.ElementColor;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.guage.AbstractProgressBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;

public class ImageProgressBarElement
extends AbstractProgressBarElement {
    protected GuiTexture bar;
    protected AssetID barID;
    protected ElementColor color;

    public ImageProgressBarElement(String id, AssetID barID, ProgressionDirection barDirection, Provider<Float> scaleProvider) {
        super(id, barDirection, scaleProvider);
        this.barID = barID;
        this.color = new ElementColor((IElement)this, Color4.WHITE);
    }

    public ImageProgressBarElement(String id, AssetID barID, ProgressionDirection barDirection, Provider<Float> scaleProvider, AssetID color) {
        super(id, barDirection, scaleProvider);
        this.barID = barID;
        this.color = new ElementColor((IElement)this, color);
    }

    @Override
    protected void renderBar(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks, float scale) {
        GuiUtils.drawProgressBar(matrixStack, this.color.getColor(), this.bar, this.getActualX(), this.getActualY(), this.barDirection, scale);
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.bar = current.getTexture(this.barID);
        this.color.onThemeChanged(current);
        this.width = this.bar.width;
        this.height = this.bar.height;
    }

    @Override
    public int getSizeX() {
        return this.bar.width;
    }

    @Override
    public int getSizeY() {
        return this.bar.height;
    }
}

