/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.BaseContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;

public abstract class BaseListContainerElement
extends BaseContainerElement {
    protected List<IElement> elements = Lists.newArrayList();

    public BaseListContainerElement(String id) {
        super(id);
    }

    @Override
    @NotNull
    protected List<IElement> getElementList() {
        return this.elements;
    }

    public void addElement(IElement element) {
        if (element != null) {
            this.elements.add(element);
            if (element instanceof IElementContainer) {
                ((IElementContainer)((Object)element)).initContainer();
            }
            element.setOwner(this);
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.load(ct);
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.save(ct);
        }
        return nbt;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elements);
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        GuiUtils.drawBackground(matrixStack, mouseX, mouseY, partialTicks, this, this.elements);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        GuiUtils.drawForeground(matrixStack, mouseX, mouseY, this, this.elements);
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
        GuiUtils.drawTooltips(matrixStack, mouseX, mouseY, this, this.elements);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseClickedCheckAll(mouseX, mouseY, mouseButton, this, this.elements);
        return false;
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseReleasedCheckAll(mouseX, mouseY, mouseButton, this, this.elements);
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        GuiUtils.mouseDraggedCheckAll(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd, this, this.elements);
        return false;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        GuiUtils.mouseScrolledCheckAll(mouseX, mouseY, scrolled, this, this.elements);
        return false;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        GuiUtils.keyPressedCheckAll(key, scanCode, modifiers, this, this.elements);
        return false;
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        GuiUtils.keyReleasedCheckAll(key, scanCode, modifiers, this, this.elements);
        return false;
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        GuiUtils.charTypedCheckAll(ch, modifiers, this, this.elements);
        return false;
    }
}

