/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.IVLScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GridAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;

public abstract class VLScreen
extends Screen
implements IVLScreen,
IElementContainer,
IElementInput,
IElementDraw {
    protected Theme theme = ThemeRegistryClient.getInstance().getTheme(ThemeRegistry.DEFAULT);
    protected Map<IElement, ElementPosition> elements = new HashMap<IElement, ElementPosition>();
    protected List<IElement> elementList = new ArrayList<IElement>();
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected GridAlignment sideMenuGrid;

    protected VLScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public final void addElement(IElement ele, int x, int y) {
        if (ele != null) {
            ElementPosition pos = new ElementPosition(x, y);
            this.elements.put(ele, pos);
            this.elementList.add(ele);
            ele.setOwner(this);
        }
    }

    public void func_231149_a_(int width, int height) {
        this.xSize = width;
        this.ySize = height;
    }

    @Override
    public IVLScreen getScreen() {
        return this;
    }

    protected int getSideMenuX() {
        return -12 + this.sideMenuGrid.getCurrentXOffset();
    }

    protected int getSizeMenuY() {
        return 4 + this.sideMenuGrid.getCurrentYOffset();
    }

    protected void nextMenuButton() {
        this.sideMenuGrid.next();
    }

    protected void addElementsPre() {
    }

    protected abstract void addElements();

    protected void addElementsPost() {
    }

    protected final void func_231160_c_() {
        this.sideMenuGrid = new GridAlignment(12, 12, 0, 2, 1, Alignment.HORIZONTAL);
        this.guiLeft = (int)Math.floor((double)this.field_230708_k_ / 2.0) - this.xSize / 2;
        this.guiTop = (int)Math.floor((double)this.field_230709_l_ / 2.0) - this.ySize / 2;
        this.initContainer();
    }

    public final void func_231023_e_() {
        super.func_231023_e_();
        this.update();
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_230446_a_(matrixStack);
        this.drawGuiContainerBackgroundLayer(matrixStack, p_render_3_, p_render_1_, p_render_2_);
        this.drawGuiContainerForegroundLayer(matrixStack, p_render_1_, p_render_2_);
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
    }

    protected final void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.renderBg(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected final void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderFg(matrixStack, mouseX, mouseY);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.guiLeft, (double)this.guiTop, 0.0);
        this.drawTooltips(matrixStack, mouseX, mouseY);
        matrixStack.func_227865_b_();
    }

    public final void closeGui() {
        super.func_231175_as__();
    }

    @Override
    public int getGuiX() {
        return this.guiLeft;
    }

    @Override
    public int getGuiY() {
        return this.guiTop;
    }

    @Override
    public int getGuiWidth() {
        return this.field_230708_k_;
    }

    @Override
    public int getGuiHeight() {
        return this.field_230709_l_;
    }

    @Override
    public Screen getAsScreen() {
        return this;
    }

    @Override
    public final void initContainer() {
        this.elementList = Lists.newArrayList();
        this.elements = Maps.newHashMap();
        this.addElementsPre();
        this.addElements();
        this.addElementsPost();
        GuiUtils.initContainerAll(this.elementList);
        this.onThemeChanged(this.theme);
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    @Override
    public final int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getX();
        }
        return 0;
    }

    @Override
    public final int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getY();
        }
        return 0;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        GuiUtils.drawBackground(matrixStack, mouseX, mouseY, partialTicks, this, this.elementList);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        GuiUtils.drawForeground(matrixStack, mouseX, mouseY, this, this.elementList);
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, double mouseX, double mouseY) {
        GuiUtils.drawTooltips(matrixStack, mouseX, mouseY, this, this.elementList);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        GuiUtils.mouseClickedCheckAll(mouseX, mouseY, button, this, this.elementList);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        GuiUtils.mouseReleasedCheckAll(mouseX, mouseY, button, this, this.elementList);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        GuiUtils.mouseDraggedCheckAll(mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll, this, this.elementList);
        return super.func_231045_a_(mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll);
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        return false;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        GuiUtils.mouseScrolledCheckAll(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_, this, this.elementList);
        return super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    public boolean emouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double scrolled) {
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.onCloseKeysPressed();
        }
        GuiUtils.keyPressedCheckAll(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_, this, this.elementList);
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        return false;
    }

    protected void onCloseKeysPressed() {
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        GuiUtils.keyReleasedCheckAll(keyCode, scanCode, modifiers, this, this.elementList);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        GuiUtils.charTypedCheckAll(p_charTyped_1_, p_charTyped_2_, this, this.elementList);
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        return false;
    }

    @Override
    public final String getID() {
        return this.getRawID();
    }

    @Override
    public String getRawID() {
        return "main";
    }

    @Override
    public final int getActualX() {
        return this.guiLeft;
    }

    @Override
    public final int getActualY() {
        return this.guiTop;
    }

    @Override
    public final int getSizeX() {
        return this.xSize;
    }

    @Override
    public final int getSizeY() {
        return this.ySize;
    }

    @Override
    public final void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(current, this.elementList);
    }

    @Override
    public final Theme getTheme() {
        return this.theme;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elementList);
    }
}

