/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container.item;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function2a;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.ItemStackUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;

public class VLInventory
implements IVLSerializableInventory {
    protected static final ItemStack E = ItemStack.field_190927_a;
    protected Function2a<Integer, ItemStack, Boolean> canPlace = (i, is) -> true;
    protected List<IInventoryChangedListener> listeners;
    protected NonNullList<ItemStack> contents;
    protected List<IOMode> slotModes;

    public VLInventory(int size) {
        this.contents = NonNullList.func_191197_a((int)size, (Object)E);
        this.slotModes = Lists.newArrayList();
        for (int i2 = 0; i2 < size; ++i2) {
            this.slotModes.add(IOMode.BOTH);
        }
    }

    public VLInventory(List<IOMode> slots) {
        this.contents = NonNullList.func_191197_a((int)slots.size(), (Object)E);
        this.slotModes = slots;
    }

    public VLInventory(IOMode ... slots) {
        this(Lists.newArrayList((Object[])slots));
    }

    public void setCanPlace(Function2a<Integer, ItemStack, Boolean> canPlace) {
        if (canPlace == null) {
            return;
        }
        this.canPlace = canPlace;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.canPlace.execute(index, stack);
    }

    @Override
    public IVLSerializableInventory copy(boolean withData) {
        VLInventory inv = new VLInventory(this.slotModes);
        if (withData) {
            int i = 0;
            for (ItemStack is : this.contents) {
                inv.func_70299_a(i, is.func_77946_l());
                ++i;
            }
        }
        return inv;
    }

    @Override
    public IVLSerializableInventory copyWithValidators(boolean withData) {
        VLInventory inv = (VLInventory)this.copy(withData);
        inv.canPlace = this.canPlace;
        return inv;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT inv = new CompoundNBT();
        ItemStackUtils.saveAllItems(inv, this.contents);
        return inv;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        ItemStackUtils.loadAllItems(compoundNBT, this.contents);
    }

    public boolean func_191420_l() {
        ItemStack slot;
        Iterator var1 = this.contents.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((slot = (ItemStack)var1.next()).func_190926_b());
        return false;
    }

    public void func_70296_d() {
        if (this.listeners != null) {
            for (IInventoryChangedListener listener : this.listeners) {
                listener.func_76316_a((IInventory)this);
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.contents.clear();
        this.func_70296_d();
    }

    public String toString() {
        return this.contents.stream().filter(p_223371_0_ -> !p_223371_0_.func_190926_b()).collect(Collectors.toList()).toString();
    }

    @Override
    public IOMode getSlotMode(int slot) {
        return this.slotModes.get(slot);
    }

    @Override
    public List<IOMode> getSlotModes() {
        return this.slotModes;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.contents.size()) {
            throw new RuntimeException("Slot " + slot + " is outside of inventorys range: [0-" + this.contents.size() + "]");
        }
    }

    public void addListener(IInventoryChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IInventoryChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void fillStackedContents(RecipeItemHelper recipeHelper) {
        for (ItemStack stack : this.contents) {
            recipeHelper.func_194112_a(stack);
        }
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        this.add(copy);
        if (copy.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.putInEmpty(copy);
        return copy.func_190926_b() ? ItemStack.field_190927_a : copy;
    }

    private void putInEmpty(ItemStack item) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack slot = this.func_70301_a(i);
            if (!slot.func_190926_b()) continue;
            this.func_70299_a(i, item.func_77946_l());
            item.func_190920_e(0);
            return;
        }
    }

    private void add(ItemStack item) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack slot = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)slot, (ItemStack)item)) continue;
            this.combine(item, slot);
            if (!item.func_190926_b()) continue;
            return;
        }
    }

    private void combine(ItemStack stack, ItemStack stack2) {
        int maxStack = Math.min(this.func_70297_j_(), stack2.func_77976_d());
        int insertable = Math.min(stack.func_190916_E(), maxStack - stack2.func_190916_E());
        if (insertable > 0) {
            stack2.func_190917_f(insertable);
            stack.func_190918_g(insertable);
            this.func_70296_d();
        }
    }

    public List<ItemStack> getAllReadOnly() {
        return Collections.unmodifiableList(this.contents);
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.contents.size() ? (ItemStack)this.contents.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amnt) {
        ItemStack split = ItemStackUtils.getAndSplit(this.contents, slot, amnt);
        this.func_70296_d();
        return split;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = (ItemStack)this.contents.get(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        this.contents.set(slot, (Object)ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.contents.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.contents.size();
    }
}

