/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container;

import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import net.minecraft.item.ItemStack;

public interface IIOHandler
extends ITick {
    public static final int ALLOWED_PROCESSES_PER_TICK = 100;

    default public int getAllowedProcessesPerTick() {
        return 100;
    }

    public void setInputSlotIndex(int var1);

    public void setBufferSlotIndex(int var1);

    public void setOutputSlotIndex(int var1);

    default public void setSlotIndices(int input_slot_index, int buffer_slot_index, int output_slot_index) {
        this.setInputSlotIndex(input_slot_index);
        this.setBufferSlotIndex(buffer_slot_index);
        this.setOutputSlotIndex(output_slot_index);
    }

    public void ignoreInternalStorageInputRate(boolean var1);

    public void ignoreInternalStorageOutputRate(boolean var1);

    public void ignoreItemStorageInputRate(boolean var1);

    public void ignoreItemStorageOutputRate(boolean var1);

    default public void ignoreRatesForInput(boolean ignore) {
        this.ignoreInternalStorageInputRate(ignore);
        this.ignoreItemStorageOutputRate(ignore);
    }

    default public void ignoreRatesForOutput(boolean ignore) {
        this.ignoreInternalStorageOutputRate(ignore);
        this.ignoreItemStorageInputRate(ignore);
    }

    public boolean isInternalStorageInputRateIgnored();

    public boolean isInternalStorageOutputRateIgnored();

    public boolean isItemInputRateIgnored();

    public boolean isItemOutputRateIgnored();

    default public boolean areRatesForInputIgnored() {
        return this.isInternalStorageInputRateIgnored() && this.isItemOutputRateIgnored();
    }

    default public boolean areRatesForOutputIgnored() {
        return this.isInternalStorageOutputRateIgnored() && this.isItemInputRateIgnored();
    }

    public void toggleIOMode();

    public EnumIO getIOMode();

    public boolean isInternalStorageEmpty();

    public boolean isInternalStorageFull();

    public boolean isItemStorageEmpty(ItemStack var1);

    public boolean isItemStorageFull(ItemStack var1);

    public int getInternalStorageStoredAmount();

    public int getItemStorageStoredAmount(ItemStack var1);

    public int getInternalStorageInputRate();

    public int getInternalStorageOutputRate();

    public int getItemStorageInputRate(ItemStack var1);

    public int getItemStorageOutputRate(ItemStack var1);

    public int transferFromItemStorageToInternalStorage(ItemStack var1, int var2);

    public int transferFromInternalStorageToItemStorage(ItemStack var1, int var2);

    default public int howManyItemsToProcessPerBufferSlot() {
        return 1;
    }

    default public int getItemStorageMinimumTransferUnitSize(ItemStack itemStack) {
        return 1;
    }

    default public boolean canProcess() {
        return this.getIOMode() == EnumIO.INPUT ? !this.isInternalStorageFull() && this.getInternalStorageInputRate() != 0 : !this.isInternalStorageEmpty() && this.getInternalStorageOutputRate() != 0;
    }

    default public boolean canItemBeProcessed(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return this.getIOMode() == EnumIO.INPUT ? !this.isItemStorageEmpty(itemStack) : !this.isItemStorageFull(itemStack);
    }

    default public boolean isProcessingComplete(ItemStack itemStack) {
        return this.getIOMode() == EnumIO.INPUT ? this.isItemStorageEmpty(itemStack) : this.isItemStorageFull(itemStack);
    }

    default public boolean processItem(ItemStack itemStack) {
        int processCount = 0;
        int initialItemStorageStoredAmount = this.getItemStorageStoredAmount(itemStack);
        int initialInternalStorageStoredAmount = this.getInternalStorageStoredAmount();
        if (this.getIOMode() == EnumIO.INPUT) {
            int internalStorageInputRate = this.getInternalStorageInputRate();
            int itemStorageOutputRate = this.getItemStorageOutputRate(itemStack);
            if (internalStorageInputRate < this.getItemStorageMinimumTransferUnitSize(itemStack)) {
                return false;
            }
            int totalTransferred = this.transferFromItemStorageToInternalStorage(itemStack, Math.min(internalStorageInputRate, itemStorageOutputRate));
            if (initialInternalStorageStoredAmount == this.getInternalStorageStoredAmount() && initialItemStorageStoredAmount == this.getItemStorageStoredAmount(itemStack)) {
                return true;
            }
            if (this.areRatesForInputIgnored()) {
                while (!this.isProcessingComplete(itemStack)) {
                    if (this.transferFromItemStorageToInternalStorage(itemStack, Integer.MAX_VALUE) == 0) {
                        return false;
                    }
                    if (processCount++ < this.getAllowedProcessesPerTick()) continue;
                    return false;
                }
                return true;
            }
            if (this.isInternalStorageInputRateIgnored() || this.isItemOutputRateIgnored()) {
                int transferred;
                for (int toTransfer = (this.isInternalStorageInputRateIgnored() ? this.getInternalStorageOutputRate() : this.getItemStorageOutputRate(itemStack)) - totalTransferred; toTransfer > 0 && !this.isProcessingComplete(itemStack); toTransfer -= transferred) {
                    if (processCount++ >= this.getAllowedProcessesPerTick()) {
                        return false;
                    }
                    transferred = this.transferFromItemStorageToInternalStorage(itemStack, toTransfer);
                    if (transferred != 0) continue;
                    return false;
                }
            }
            return this.isProcessingComplete(itemStack);
        }
        if (this.getIOMode() == EnumIO.OUTPUT) {
            int internalStorageOutputRate = this.getInternalStorageOutputRate();
            int itemStorageInputRate = this.getItemStorageInputRate(itemStack);
            if (internalStorageOutputRate < this.getItemStorageMinimumTransferUnitSize(itemStack)) {
                return false;
            }
            int totalTransferred = this.transferFromInternalStorageToItemStorage(itemStack, Math.min(internalStorageOutputRate, itemStorageInputRate));
            if (initialInternalStorageStoredAmount == this.getInternalStorageStoredAmount() && initialItemStorageStoredAmount == this.getItemStorageStoredAmount(itemStack)) {
                return true;
            }
            if (this.areRatesForOutputIgnored()) {
                while (!this.isProcessingComplete(itemStack)) {
                    if (this.transferFromInternalStorageToItemStorage(itemStack, Integer.MAX_VALUE) == 0) {
                        return false;
                    }
                    if (processCount++ < this.getAllowedProcessesPerTick()) continue;
                    return false;
                }
                return true;
            }
            if (this.isInternalStorageOutputRateIgnored() || this.isItemInputRateIgnored()) {
                int transferred;
                for (int toTransfer = (this.isInternalStorageOutputRateIgnored() ? this.getInternalStorageOutputRate() : this.getItemStorageInputRate(itemStack)) - totalTransferred; toTransfer > 0 && !this.isProcessingComplete(itemStack); toTransfer -= transferred) {
                    if (processCount++ >= this.getAllowedProcessesPerTick()) {
                        return false;
                    }
                    transferred = this.transferFromInternalStorageToItemStorage(itemStack, toTransfer);
                    if (transferred != 0) continue;
                    return false;
                }
            }
            return this.isProcessingComplete(itemStack);
        }
        return false;
    }
}

