/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.network;

import com.valkyrieofnight.vlib.core.network.VLPacket;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private final String protocol_version;
    protected final SimpleChannel channel;
    private int id = 0;

    public NetworkHandler(String modid, String channelName, String protocol_version) {
        this.protocol_version = protocol_version;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new VLID(modid, channelName), () -> protocol_version, protocol_version::equals, protocol_version::equals);
    }

    public <MSG extends VLPacket> void registerPacket(Class<MSG> packetClass, BiConsumer<MSG, PacketBuffer> bufferWriter, Function<PacketBuffer, MSG> bufferReader, BiConsumer<MSG, Supplier<NetworkEvent.Context>> packetExecutor) {
        this.channel.registerMessage(this.id++, packetClass, bufferWriter, bufferReader, packetExecutor);
    }

    public <MSG extends VLPacket> void registerPacket(Class<MSG> packetClass, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageContext, Optional<NetworkDirection> networkDirection) {
        this.channel.registerMessage(this.id++, packetClass, encoder, decoder, messageContext, networkDirection);
    }

    public <MSG extends VLPacket> void sendToServer(MSG message) {
        this.channel.sendToServer(message);
    }

    public <MSG extends VLPacket> void sendTo(MSG message, NetworkManager manager, NetworkDirection direction) {
        this.channel.sendTo(message, manager, direction);
    }

    public <MSG extends VLPacket> void send(PacketDistributor.PacketTarget target, MSG message) {
        this.channel.send(target, message);
    }

    public <MSG extends VLPacket> void reply(MSG msgToReply, NetworkEvent.Context context) {
        this.channel.reply(msgToReply, context);
    }
}

