/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client;

import java.util.Locale;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.model.CauldronBackpackModel;
import net.valhelsia.valhelsia_core.client.model.CosmeticsModel;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;
import net.valhelsia.valhelsia_core.client.model.WitchsBroomModel;
import net.valhelsia.valhelsia_core.client.model.WitchsWandModel;

public enum CosmeticsModels {
    CAPE(new ValhelsiaCapeModel<T>()),
    WITCH_HAT(new WitchHatModel<T>()),
    WITCHS_BROOM(new WitchsBroomModel<T>()),
    WITCHS_WAND(new WitchsWandModel<T>()),
    CAULDRON_BACKPACK(new CauldronBackpackModel<T>());

    private final CosmeticsModel<?> model;

    private CosmeticsModels(CosmeticsModel<?> model) {
        this.model = model;
    }

    public CosmeticsModel<?> getModel() {
        return this.model;
    }

    public static CosmeticsModel<?> getFromCosmetic(Cosmetic cosmetic) {
        String name = cosmetic.getName();
        if (name.contains("cape")) {
            return CAPE.getModel();
        }
        if (name.contains("witch_hat")) {
            return WITCH_HAT.getModel();
        }
        if (name.contains("witchs_wand")) {
            return WITCHS_WAND.getModel();
        }
        return CosmeticsModels.valueOf(name.toUpperCase(Locale.ROOT)).getModel();
    }
}

