/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElement {
    private final List<GuiElement> childElements = new ArrayList<GuiElement>();
    private int posX;
    private int posY;
    private int sizeX;
    private int sizeY;

    public GuiElement(int posX, int posY, int sizeX, int sizeY) {
        this.posX = posX;
        this.posY = posY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public void init() {
        this.childElements.forEach(GuiElement::init);
    }

    public void render(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.childElements.forEach(element -> element.render(stack, mouseX, mouseY, partialTicks));
    }

    public void renderHoverEffect(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.childElements.forEach(element -> {
            if (element.isMouseOver(mouseX, mouseY)) {
                element.renderHoverEffect(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    public boolean onClicked(double mouseX, double mouseY, int button) {
        for (GuiElement element : this.childElements) {
            if (!element.isMouseOver(mouseX, mouseY) || !element.onClicked(this.posX, this.posY, button)) continue;
            return true;
        }
        return false;
    }

    public List<GuiElement> getChildElements() {
        return this.childElements;
    }

    public boolean addChildElement(GuiElement element) {
        if (this.childElements.contains(element)) {
            return false;
        }
        element.init();
        return this.childElements.add(element);
    }

    public boolean removeChildElement(GuiElement element) {
        if (!this.childElements.contains(element)) {
            return false;
        }
        return this.childElements.remove(element);
    }

    public Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    public Screen getCurrentScreen() {
        return this.getMinecraft().field_71462_r;
    }

    public void bindTexture(ResourceLocation texture) {
        this.getMinecraft().func_110434_K().func_110577_a(texture);
    }

    public void blit(MatrixStack matrixStack, int blitOffset, int startX, int startY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        this.blit(matrixStack, this.getPosX(), this.getPosY(), blitOffset, startX, startY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    public void blit(MatrixStack matrixStack, int posX, int posY, int blitOffset, int startX, int startY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)posX, (int)posY, (int)blitOffset, (float)startX, (float)startY, (int)sizeX, (int)sizeY, (int)textureSizeX, (int)textureSizeY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPosX() && mouseY >= (double)this.getPosY() && mouseX <= (double)this.getEndX() && mouseY <= (double)this.getEndY();
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    public int getEndX() {
        return this.posX + this.sizeX;
    }

    public int getEndY() {
        return this.posY + this.sizeY;
    }
}

