/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.valhelsia.valhelsia_core.client.Bundles;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.CosmeticsCategory;
import net.valhelsia.valhelsia_core.util.TextureDownloader;

public class CosmeticsManager {
    private final List<UUID> loadedPlayers = new ArrayList<UUID>();
    private final Map<UUID, List<Cosmetic>> cosmetics = new HashMap<UUID, List<Cosmetic>>();
    private final Map<UUID, CompoundNBT> activeCosmetics = new HashMap<UUID, CompoundNBT>();
    private final Map<String, ResourceLocation> loadedTextures = new HashMap<String, ResourceLocation>();
    private static CosmeticsManager instance;

    public static CosmeticsManager getInstance() {
        if (instance == null) {
            instance = new CosmeticsManager();
        }
        return instance;
    }

    public void tryLoadCosmeticsForPlayer(UUID uuid, @Nullable DataAvailableCallback callback) {
        if (this.loadedPlayers.contains(uuid)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URL("https://valhelsia.net/api/webhook/mod/valhelsia_core/purchases?uuid=" + uuid.toString().replace("-", ""));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                InputStream stream = connection.getInputStream();
                if (connection.getResponseCode() != 200) {
                    if (stream != null) {
                        stream.close();
                    }
                    if (connection.getErrorStream() != null) {
                        connection.getErrorStream().close();
                    }
                } else if (stream != null) {
                    this.loadCosmeticsForPlayer(uuid, JSONUtils.func_212743_a((Reader)new InputStreamReader(stream)), callback);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, Util.func_215072_e());
        this.loadedPlayers.add(uuid);
    }

    private void loadCosmeticsForPlayer(UUID uuid, JsonObject jsonObject, @Nullable DataAvailableCallback callback) {
        if (!jsonObject.has("data")) {
            return;
        }
        JsonArray purchases = jsonObject.getAsJsonObject("data").getAsJsonArray("purchases");
        for (JsonElement purchase : purchases) {
            String name = purchase.getAsJsonObject().get("name").getAsString().toLowerCase(Locale.ROOT).replace(" ", "_").replace("'", "");
            this.cosmetics.computeIfAbsent(uuid, k -> new ArrayList());
            if (name.contains("bundle")) {
                Bundles.getCosmeticsFromBundle(name).forEach(s -> this.addCosmeticToPlayer(uuid, new Cosmetic((String)s, CosmeticsCategory.getForCosmetic(s))));
                continue;
            }
            this.addCosmeticToPlayer(uuid, new Cosmetic(name, CosmeticsCategory.getForCosmetic(name)));
        }
        if (callback != null) {
            callback.onDataAvailable();
        }
    }

    private void addCosmeticToPlayer(UUID uuid, Cosmetic cosmetic) {
        boolean flag = true;
        for (Cosmetic cosmetic1 : this.cosmetics.get(uuid)) {
            if (!cosmetic1.equals(cosmetic)) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.cosmetics.get(uuid).add(cosmetic);
        }
    }

    public List<Cosmetic> getCosmeticsForPlayer(UUID uuid) {
        return this.cosmetics.getOrDefault(uuid, new ArrayList());
    }

    public List<Cosmetic> getCosmeticsForPlayer(UUID uuid, CosmeticsCategory category) {
        return ((List)this.cosmetics.getOrDefault(uuid, new ArrayList())).stream().filter(cosmetic -> cosmetic.getCategory() == category).collect(Collectors.toList());
    }

    public List<UUID> getLoadedPlayers() {
        return this.loadedPlayers;
    }

    public void loadCosmeticTexture(Cosmetic cosmetic, @Nullable CosmeticsCategory category) {
        String cosmeticName = cosmetic.getName();
        if (!this.loadedTextures.containsKey(cosmeticName)) {
            try {
                TextureDownloader.downloadTexture(new URL("https://static.valhelsia.net/cosmetics/" + cosmeticName + ".png"), "cosmetics/", texture -> this.loadedTextures.put(cosmeticName, texture));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (category == CosmeticsCategory.BACK && cosmeticName.contains("cape")) {
                String name = cosmeticName.substring(0, cosmeticName.length() - 4).concat("elytra");
                try {
                    TextureDownloader.downloadTexture(new URL("https://static.valhelsia.net/cosmetics/" + name + ".png"), "cosmetics/", texture -> this.loadedTextures.put(name, texture));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public CompoundNBT getActiveCosmeticsForPlayer(UUID uuid) {
        return this.activeCosmetics.containsKey(uuid) ? this.activeCosmetics.get(uuid) : new CompoundNBT();
    }

    @Nullable
    public Cosmetic getActiveCosmeticForPlayer(UUID uuid, CosmeticsCategory category) {
        if (this.getActiveCosmeticsForPlayer(uuid) != null && this.getActiveCosmeticsForPlayer(uuid).func_74764_b(category.getName())) {
            return Cosmetic.fromTag(this.getActiveCosmeticsForPlayer(uuid).func_74775_l(category.getName()), category);
        }
        return null;
    }

    public void setActiveCosmeticsForPlayer(UUID uuid, CompoundNBT activeCosmetics) {
        this.activeCosmetics.put(uuid, activeCosmetics);
    }

    public ResourceLocation getCosmeticTexture(Cosmetic cosmetic) {
        if (!this.loadedTextures.containsKey(cosmetic.getName())) {
            this.loadCosmeticTexture(cosmetic, null);
        }
        return this.loadedTextures.get(cosmetic.getName());
    }

    public static interface DataAvailableCallback {
        public void onDataAvailable();
    }
}

