/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.api.gui.IBackgroundColorProvider;
import info.u_team.u_team_core.api.gui.IPerspectiveRenderable;
import info.u_team.u_team_core.api.gui.ITextProvider;
import info.u_team.u_team_core.api.gui.ITextureProvider;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.elements.WidgetTextureProvider;
import info.u_team.u_team_core.util.GuiUtil;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class USlider
extends Slider
implements IPerspectiveRenderable,
IBackgroundColorProvider,
ITextProvider {
    protected static final Slider.ISlider EMTPY_SLIDER = slider -> {};
    protected static final Button.ITooltip EMPTY_TOOLTIP = UButton.EMPTY_TOOLTIP;
    protected static final RGBA WHITE = UButton.WHITE;
    protected static final RGBA LIGHT_GRAY = UButton.LIGHT_GRAY;
    protected final boolean isInContainer;
    protected ITextureProvider sliderBackgroundTextureProvider;
    protected RGBA sliderBackgroundColor;
    protected RGBA sliderColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;

    public USlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, EMTPY_SLIDER);
    }

    public USlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Slider.ISlider slider) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, slider, EMPTY_TOOLTIP);
    }

    public USlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Button.ITooltip tooltip) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, EMTPY_SLIDER, tooltip);
    }

    public USlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Slider.ISlider slider, Button.ITooltip tooltip) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, UButton.EMTPY_PRESSABLE, slider);
        this.isInContainer = isInContainer;
        this.field_238487_u_ = tooltip;
        this.sliderBackgroundTextureProvider = new WidgetTextureProvider((Widget)this, arg_0 -> ((USlider)this).func_230989_a_(arg_0));
        this.sliderBackgroundColor = WHITE;
        this.sliderColor = WHITE;
        this.textColor = WHITE;
        this.disabledTextColor = LIGHT_GRAY;
    }

    public void setSlider(Slider.ISlider slider) {
        this.parent = slider;
    }

    public void setSlider(Runnable runnable) {
        this.parent = slider -> runnable.run();
    }

    public void setTooltip(Button.ITooltip tooltip) {
        this.field_238487_u_ = tooltip;
    }

    public RGBA getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public void setSliderBackgroundColor(RGBA sliderBackgroundColor) {
        this.sliderBackgroundColor = sliderBackgroundColor;
    }

    public RGBA getSliderColor() {
        return this.sliderColor;
    }

    public void setSliderColor(RGBA sliderColor) {
        this.sliderColor = sliderColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderButtonLikeWidget(this, this.sliderBackgroundTextureProvider, matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.func_230441_a_(matrixStack, minecraft, mouseX, mouseY);
        if (this.field_230694_p_) {
            RenderUtil.enableBlend();
            RenderUtil.defaultBlendFunc();
            GuiUtil.drawContinuousTexturedBox(matrixStack, field_230687_i_, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 66 + (this.func_230449_g_() ? 20 : 0), 8, this.field_230689_k_, 200, 20, 2, 3, 2, 2, this.func_230927_p_(), this.getCurrentSliderColor(matrixStack, mouseX, mouseY, partialTicks));
            RenderUtil.disableBlend();
        }
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderText(this, matrixStack, minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderToolTip(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.func_230443_a_(matrixStack, mouseX, mouseY);
    }

    @Override
    public RGBA getCurrentBackgroundColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderBackgroundColor;
    }

    public RGBA getCurrentSliderColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderColor;
    }

    @Override
    public ITextComponent getCurrentText() {
        return this.func_230458_i_();
    }

    @Override
    public RGBA getCurrentTextColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.field_230693_o_ ? this.textColor : this.disabledTextColor;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.changeSliderValue(mouseX);
        if (this.isInContainer) {
            this.dragging = true;
        }
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.isInContainer) {
            this.changeSliderValue(mouseX);
        }
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        if (this.func_230449_g_()) {
            super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
        }
        if (this.isInContainer) {
            this.dragging = false;
        }
    }

    protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isInContainer && this.field_230694_p_ && this.dragging) {
            this.changeSliderValue(mouseX);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float direction = flag ? -1.0f : 1.0f;
            this.setSliderValue(this.sliderValue + (double)(direction / (float)(this.field_230688_j_ - 8)));
        }
        return false;
    }

    public void func_230988_a_(SoundHandler handler) {
    }

    protected IFormattableTextComponent func_230442_c_() {
        return new TranslationTextComponent("gui.narrate.slider", new Object[]{this.func_230458_i_()});
    }

    protected void changeSliderValue(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
    }

    protected void setSliderValue(double value) {
        double oldValue = this.sliderValue;
        this.sliderValue = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.sliderValue) {
            this.updateSlider();
        }
    }
}

