/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.api.gui.IBackgroundColorProvider;
import info.u_team.u_team_core.api.gui.IPerspectiveRenderable;
import info.u_team.u_team_core.api.gui.IRenderTickable;
import info.u_team.u_team_core.api.gui.ITextColorProvider;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;

public class UTextField
extends TextFieldWidget
implements IRenderTickable,
IPerspectiveRenderable,
IBackgroundColorProvider,
ITextColorProvider {
    protected static final ITooltip EMPTY_TOOLTIP = (textField, matrixStack, mouseX, mouseY) -> {};
    protected static final RGBA BLACK = RGBA.BLACK;
    protected static final RGBA WHITE = RGBA.WHITE;
    protected static final RGBA LIGHT_GRAY = new RGBA(-522133249);
    protected static final RGBA LIGHTER_GRAY = new RGBA(-791621377);
    protected static final RGBA GRAY = new RGBA(-1600085761);
    protected static final RGBA DARKER_GRAY = new RGBA(-2139062017);
    protected static final RGBA DARK_GRAY = new RGBA(0x707070FF);
    protected ITooltip onTooltip;
    protected RGBA backgroundFrameColor;
    protected RGBA unfocusedBackgroundFrameColor;
    protected RGBA backgroundColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;
    protected RGBA suggestionTextColor;
    protected RGBA cursorColor;

    public UTextField(FontRenderer fontRenderer, int x, int y, int width, int height, UTextField previousTextField, ITextComponent title) {
        this(fontRenderer, x, y, width, height, previousTextField, title, EMPTY_TOOLTIP);
    }

    public UTextField(FontRenderer fontRenderer, int x, int y, int width, int height, UTextField previousTextField, ITextComponent title, ITooltip tooltip) {
        super(fontRenderer, x, y, width, height, title);
        this.setPreviousText(previousTextField);
        this.onTooltip = tooltip;
        this.backgroundFrameColor = WHITE;
        this.unfocusedBackgroundFrameColor = GRAY;
        this.backgroundColor = BLACK;
        this.textColor = LIGHT_GRAY;
        this.disabledTextColor = DARK_GRAY;
        this.suggestionTextColor = DARKER_GRAY;
        this.cursorColor = LIGHTER_GRAY;
    }

    public void setTooltip(ITooltip tooltip) {
        this.onTooltip = tooltip;
    }

    public RGBA getBackgroundFrameColor() {
        return this.backgroundFrameColor;
    }

    public void setBackgroundFrameColor(RGBA backgroundFrameColor) {
        this.backgroundFrameColor = backgroundFrameColor;
    }

    public RGBA getUnfocusedBackgroundFrameColor() {
        return this.unfocusedBackgroundFrameColor;
    }

    public void setUnfocusedBackgroundFrameColor(RGBA unfocusedBackgroundFrameColor) {
        this.unfocusedBackgroundFrameColor = unfocusedBackgroundFrameColor;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public RGBA getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public void setSuggestionTextColor(RGBA suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
    }

    public RGBA getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(RGBA cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void func_146193_g(int color) {
        super.func_146193_g(color);
        this.setTextColor(RGBA.fromARGB(color));
    }

    public void func_146204_h(int color) {
        super.func_146204_h(color);
        this.setDisabledTextColor(RGBA.fromARGB(color));
    }

    public void setPreviousText(UTextField textField) {
        if (textField != null) {
            this.field_146216_j = textField.field_146216_j;
            this.field_146217_k = textField.field_146217_k;
            this.field_146225_q = textField.field_146225_q;
            this.field_146224_r = textField.field_146224_r;
            this.field_146223_s = textField.field_146223_s;
        }
    }

    @Override
    public void renderTick() {
        this.func_146178_a();
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.renderBackground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
        this.renderForeground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146215_m) {
            UTextField.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)this.getCurrentBackgroundFrameColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
            UTextField.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.getCurrentBackgroundColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        RGBA currentTextColor = this.getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks);
        String currentText = this.field_146211_a.func_238412_a_(this.field_146216_j.substring(this.field_146225_q), this.func_146200_o());
        int cursorOffset = this.field_146224_r - this.field_146225_q;
        int selectionOffset = Math.min(this.field_146223_s - this.field_146225_q, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.func_230999_j_() && this.field_146214_l / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.field_146224_r < this.field_146216_j.length() || this.field_146216_j.length() >= this.field_146217_k;
        int xOffset = this.field_146215_m ? this.field_230690_l_ + 4 : this.field_230690_l_;
        int yOffset = this.field_146215_m ? this.field_230691_m_ + (this.field_230689_k_ - 8) / 2 : this.field_230691_m_;
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = this.field_146211_a.func_238407_a_(matrixStack, (IReorderingProcessor)this.field_195613_A.apply(firstTextPart, this.field_146225_q), (float)xOffset, (float)yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.field_230688_j_ : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            this.field_146211_a.func_238407_a_(matrixStack, (IReorderingProcessor)this.field_195613_A.apply(currentText.substring(cursorOffset), this.field_146224_r), (float)leftRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
        }
        if (!isCursorInTheMiddle && this.field_195614_x != null) {
            this.field_146211_a.func_238405_a_(matrixStack, this.field_195614_x, (float)(rightRenderedTextX - 1), (float)yOffset, this.getCurrentSuggestionTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)rightRenderedTextX, (int)(yOffset - 1), (int)(rightRenderedTextX + 1), (int)(yOffset + 1 + 9), (int)this.getCurrentCursorColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
            } else {
                this.field_146211_a.func_238405_a_(matrixStack, "_", (float)rightRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.field_146211_a.func_78256_a(currentText.substring(0, selectionOffset));
            this.func_146188_c(rightRenderedTextX, yOffset - 1, selectedX - 1, yOffset + 1 + 9);
        }
    }

    @Override
    public void renderToolTip(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.func_230443_a_(matrixStack, mouseX, mouseY);
    }

    public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.onTooltip.onTooltip(this, matrixStack, mouseX, mouseY);
    }

    @Override
    public RGBA getCurrentBackgroundColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.backgroundColor;
    }

    public RGBA getCurrentBackgroundFrameColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.func_230999_j_() ? this.backgroundFrameColor : this.unfocusedBackgroundFrameColor;
    }

    @Override
    public RGBA getCurrentTextColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.field_146226_p ? this.textColor : this.disabledTextColor;
    }

    public RGBA getCurrentSuggestionTextColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.suggestionTextColor;
    }

    public RGBA getCurrentCursorColor(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.cursorColor;
    }

    @FunctionalInterface
    public static interface ITooltip {
        public void onTooltip(UTextField var1, MatrixStack var2, int var3, int var4);
    }
}

