/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.container;

import info.u_team.u_team_core.api.fluid.IFluidHandlerModifiable;
import info.u_team.u_team_core.inventory.UFluidStackHandler;
import net.minecraftforge.fluids.FluidStack;

public class FluidSlot {
    private final IFluidHandlerModifiable fluidHandler;
    private final int index;
    private final int x;
    private final int y;
    public int slotNumber;

    public FluidSlot(IFluidHandlerModifiable fluidHandler, int index, int x, int y) {
        this.fluidHandler = fluidHandler;
        this.index = index;
        this.x = x;
        this.y = y;
    }

    public boolean isFluidValid(FluidStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.fluidHandler.isFluidValid(this.index, stack);
    }

    public FluidStack getStack() {
        return this.fluidHandler.getFluidInTank(this.index);
    }

    public void putStack(FluidStack stack) {
        this.fluidHandler.setFluidInTank(this.index, stack);
        this.onSlotChanged();
    }

    public void onSlotChanged() {
        if (this.fluidHandler instanceof UFluidStackHandler) {
            ((UFluidStackHandler)this.fluidHandler).onContentsChanged(this.index);
        }
    }

    public int getSlotCapacity() {
        return this.fluidHandler.getTankCapacity(this.index);
    }

    public int getSlotCurrentyCapacity() {
        return this.getSlotCapacity() - this.getStack().getAmount();
    }

    public IFluidHandlerModifiable getFluidHandler() {
        return this.fluidHandler;
    }

    public int getIndex() {
        return this.index;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isEnabled() {
        return true;
    }
}

