/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import info.u_team.u_team_core.util.Predicates;
import info.u_team.useful_railroads.inventory.BlockTagItemStackHandler;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public abstract class TrackBuilderManager {
    protected final World world;
    protected final Direction direction;
    protected final BlockPos startPos;
    protected final TrackBuilderMode mode;
    protected final Set<BlockPos> allPositionSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> firstRailPos = new HashSet<BlockPos>();
    protected final Set<BlockPos> railSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> groundSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> redstoneTorchSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> cobbleSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> airSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> tunnelSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> torchSet = new HashSet<BlockPos>();

    private TrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, World world, Vector3d lookVector, TrackBuilderMode mode) {
        this.world = world;
        this.direction = Direction.func_210769_a((double)lookVector.field_72450_a, (double)lookVector.field_72448_b, (double)lookVector.field_72449_c);
        if (rayTraceFace.func_176740_k().func_176722_c()) {
            rayTracePos = rayTracePos.func_177972_a(this.direction.func_176734_d());
        }
        if (!world.func_180495_p(rayTracePos).func_200132_m()) {
            rayTracePos = rayTracePos.func_177977_b();
        }
        this.startPos = rayTracePos.func_185334_h();
        this.mode = mode;
    }

    public void calculateBlockPosition() {
        Direction directionLeft = this.direction.func_176735_f();
        Direction directionRight = this.direction.func_176746_e();
        this.calculate(directionLeft, directionRight);
        Stream.of(this.railSet, this.groundSet, this.tunnelSet, this.redstoneTorchSet, this.torchSet, this.cobbleSet, this.airSet).flatMap(Collection::stream).forEach(this.allPositionSet::add);
    }

    protected abstract void calculate(Direction var1, Direction var2);

    public void execute(PlayerEntity player, TrackBuilderInventoryWrapper wrapper) {
        if (this.world.field_72995_K || !(this.world instanceof ServerWorld)) {
            return;
        }
        int cost = this.calculateCost();
        if (wrapper.getFuel() < cost) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.usefulrailroads.track_builder.not_enough_fuel", new Object[]{cost}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return;
        }
        if (!(this.hasEnoughItems(wrapper.getRailInventory(), this.railSet) && this.hasEnoughItems(wrapper.getGroundInventory(), this.groundSet) && this.hasEnoughItems(wrapper.getTunnelInventory(), this.tunnelSet) && this.hasEnoughItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet) && this.hasEnoughItems(wrapper.getTorchInventory(), this.torchSet))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.usefulrailroads.track_builder.not_enough_blocks").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return;
        }
        wrapper.setFuel(wrapper.getFuel() - cost);
        List<ItemStack> railStacks = this.extractItems(wrapper.getRailInventory(), this.railSet);
        List<ItemStack> groundStacks = this.extractItems(wrapper.getGroundInventory(), this.groundSet);
        List<ItemStack> tunnelStacks = this.extractItems(wrapper.getTunnelInventory(), this.tunnelSet);
        List<ItemStack> redstoneTorchStacks = this.extractItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet);
        List<ItemStack> torchStacks = this.extractItems(wrapper.getTorchInventory(), this.torchSet);
        Inventory dropInventory = new Inventory(50);
        this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((World)this.world).func_175623_d(arg_0))).forEach(pos -> this.destroyBlock(player, (BlockPos)pos, dropInventory));
        InventoryHelper.func_180176_a((World)this.world, (Entity)player, (IInventory)dropInventory);
        this.cobbleSet.forEach(pos -> this.placeBlock((BlockPos)pos, Blocks.field_150347_e.func_176223_P()));
        this.redstoneTorchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(redstoneTorchStacks)));
        this.groundSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(groundStacks)));
        this.railSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(railStacks)));
        this.tunnelSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(tunnelStacks)));
        this.torchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(torchStacks), (item, block) -> {
            boolean redstoneTorch;
            boolean bl = redstoneTorch = item == Items.field_221764_cr;
            if (redstoneTorch || item == Items.field_221657_bQ) {
                Block torchWall = redstoneTorch ? Blocks.field_196677_cy : Blocks.field_196591_bQ;
                Block torchGround = redstoneTorch ? Blocks.field_150429_aA : Blocks.field_150478_aa;
                return Stream.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).map(direction -> (BlockState)torchWall.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction)).filter(state -> state.func_196955_c((IWorldReader)this.world, pos)).findAny().orElseGet(() -> ((Block)torchGround).func_176223_P());
            }
            return block.func_176223_P();
        }));
        wrapper.writeItemStack();
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack) {
        this.placeItemBlock(pos, stack, (item, block) -> block.func_176223_P());
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack, BiFunction<Item, Block, BlockState> function) {
        if (stack.func_190926_b() && !(stack.func_77973_b() instanceof BlockItem)) {
            return;
        }
        Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
        this.placeBlock(pos, function.apply(stack.func_77973_b(), block));
        BlockItem.func_179224_a((World)this.world, null, (BlockPos)pos, (ItemStack)stack);
    }

    private boolean placeBlock(BlockPos pos, BlockState state) {
        return this.placeBlock(pos, state, 3);
    }

    private boolean placeBlock(BlockPos pos, BlockState state, int flag) {
        boolean blockSnapshotValue = this.world.captureBlockSnapshots;
        this.world.captureBlockSnapshots = false;
        boolean placed = this.world.func_180501_a(pos, state, flag);
        this.world.captureBlockSnapshots = blockSnapshotValue;
        return placed;
    }

    private void destroyBlock(PlayerEntity player, BlockPos pos, Inventory inventory) {
        BlockState state = this.world.func_180495_p(pos);
        int exp = state.getExpDrop((IWorldReader)this.world, pos, 0, 0);
        if (this.placeBlock(pos, Blocks.field_150350_a.func_176223_P()) && this.world instanceof ServerWorld) {
            Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.world), (BlockPos)pos, (TileEntity)this.world.func_175625_s(pos)).stream().map(arg_0 -> ((Inventory)inventory).func_174894_a(arg_0)).filter(Predicates.not(ItemStack::func_190926_b)).forEach(stack -> Block.func_180635_a((World)this.world, (BlockPos)pos, (ItemStack)stack));
            state.func_215706_a((ServerWorld)this.world, player.func_233580_cy_(), ItemStack.field_190927_a);
            if (exp > 0) {
                state.func_177230_c().func_180637_b((ServerWorld)this.world, player.func_233580_cy_(), exp);
            }
        }
    }

    private List<ItemStack> extractItems(BlockTagItemStackHandler handler, Set<BlockPos> set) {
        return ItemHandlerUtil.extractItems((IItemHandler)handler, handler::getCondition, set.size());
    }

    private boolean hasEnoughItems(BlockTagItemStackHandler handler, Set<BlockPos> set) {
        return ItemHandlerUtil.getItemCount((IItemHandler)handler, handler::getCondition) >= set.size();
    }

    private int calculateCost() {
        int breakCount = (int)this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((World)this.world).func_175623_d(arg_0))).count();
        int placeCount = this.allPositionSet.size() - this.airSet.size();
        return breakCount * 2 + placeCount;
    }

    public Set<BlockPos> getAllPositionsSet() {
        return Collections.unmodifiableSet(this.allPositionSet);
    }

    public Set<BlockPos> getFirstRailPos() {
        return this.firstRailPos;
    }

    protected BlockPos addFirstRail(BlockPos pos) {
        this.firstRailPos.add(pos);
        return pos;
    }

    public static Optional<TrackBuilderManager> create(BlockPos rayTracePos, Direction rayTraceFace, World world, Vector3d lookVector, TrackBuilderMode mode, boolean doubleTrack) {
        TrackBuilderManager manager;
        TrackBuilderManager trackBuilderManager = manager = doubleTrack ? new DoubleTrackBuilderManager(rayTracePos, rayTraceFace, world, lookVector, mode) : new SingleTrackBuilderManager(rayTracePos, rayTraceFace, world, lookVector, mode);
        if (manager.direction.func_176740_k().func_176722_c()) {
            manager.calculateBlockPosition();
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    private static class DoubleTrackBuilderManager
    extends TrackBuilderManager {
        private DoubleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, World world, Vector3d lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, world, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.func_218281_b((BlockPos)this.addFirstRail(this.startPos.func_177972_a(this.direction).func_177972_a(directionLeft).func_177984_a()), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177972_a(directionLeft).func_177984_a()).map(BlockPos::func_185334_h).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.func_177967_a(this.direction, 9).func_177972_a(directionLeft).func_177977_b().func_185334_h());
            BlockPos.func_218281_b((BlockPos)this.addFirstRail(this.startPos.func_177972_a(this.direction).func_177972_a(directionRight).func_177984_a()), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177972_a(directionRight).func_177984_a()).map(BlockPos::func_185334_h).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.func_177967_a(this.direction, 9).func_177972_a(directionRight).func_177977_b().func_185334_h());
            BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 2), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 2)).map(BlockPos::func_185334_h).forEach(this.groundSet::add);
            BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 2).func_177977_b(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 2).func_177979_c(2)).map(BlockPos::func_185334_h).filter(Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 2).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 2).func_177981_b(4)).map(BlockPos::func_185334_h).forEach(this.airSet::add);
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 3).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 3).func_177981_b(5)).map(BlockPos::func_185334_h).filter(Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 3).func_177981_b(3).func_177967_a(directionLeft, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 7).func_177981_b(3).func_177967_a(directionLeft, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 11).func_177981_b(3).func_177967_a(directionLeft, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 15).func_177981_b(3).func_177967_a(directionLeft, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 3).func_177981_b(3).func_177967_a(directionRight, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 7).func_177981_b(3).func_177967_a(directionRight, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 11).func_177981_b(3).func_177967_a(directionRight, 2).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 15).func_177981_b(3).func_177967_a(directionRight, 2).func_185334_h());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, this.mode.getDistanceSide() + 1).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, this.mode.getDistanceSide() + 1).func_177981_b(this.mode.getDistanceUp())).map(BlockPos::func_185334_h).filter(Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }

    private static class SingleTrackBuilderManager
    extends TrackBuilderManager {
        private SingleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, World world, Vector3d lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, world, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.func_218281_b((BlockPos)this.addFirstRail(this.startPos.func_177972_a(this.direction).func_177984_a()), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177984_a()).map(BlockPos::func_185334_h).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.func_177967_a(this.direction, 9).func_177977_b().func_185334_h());
            BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177972_a(directionLeft), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177972_a(directionRight)).map(BlockPos::func_185334_h).forEach(this.groundSet::add);
            BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177972_a(directionLeft).func_177977_b(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177972_a(directionRight).func_177979_c(2)).map(BlockPos::func_185334_h).filter(Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 1).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 1).func_177981_b(4)).map(BlockPos::func_185334_h).forEach(this.airSet::add);
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, 2).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, 2).func_177981_b(5)).map(BlockPos::func_185334_h).filter(Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 5).func_177981_b(3).func_177967_a(directionLeft, 1).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 13).func_177981_b(3).func_177967_a(directionLeft, 1).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 5).func_177981_b(3).func_177967_a(directionRight, 1).func_185334_h());
                this.torchSet.add(this.startPos.func_177967_a(this.direction, 13).func_177981_b(3).func_177967_a(directionRight, 1).func_185334_h());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.func_218281_b((BlockPos)this.startPos.func_177972_a(this.direction).func_177967_a(directionLeft, this.mode.getDistanceSide()).func_177984_a(), (BlockPos)this.startPos.func_177967_a(this.direction, 17).func_177967_a(directionRight, this.mode.getDistanceSide()).func_177981_b(this.mode.getDistanceUp())).map(BlockPos::func_185334_h).filter(Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }
}

