/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.container;

import info.u_team.u_team_core.api.sync.BufferReferenceHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.container.UContainer;
import info.u_team.useful_railroads.init.UsefulRailroadsContainerTypes;
import info.u_team.useful_railroads.inventory.FuelItemSlotHandler;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.item.TrackBuilderItem;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class TrackBuilderContainer
extends UContainer {
    private final TrackBuilderInventoryWrapper wrapper;
    private final MessageHolder.EmptyMessageHolder changeModeMessage;
    private final int selectedSlot;

    public TrackBuilderContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(id, playerInventory, new TrackBuilderInventoryWrapper.Client(buffer.func_150792_a(), (TrackBuilderMode)buffer.func_179257_a(TrackBuilderMode.class), () -> playerInventory.field_70458_d.field_70170_p), buffer.func_150792_a());
    }

    public TrackBuilderContainer(int id, PlayerInventory playerInventory, TrackBuilderInventoryWrapper wrapper, int selectedSlot) {
        super((ContainerType)UsefulRailroadsContainerTypes.TRACK_BUILDER.get(), id);
        this.wrapper = wrapper;
        this.selectedSlot = selectedSlot;
        this.appendInventory(wrapper.getFuelInventory(), FuelItemSlotHandler::new, 1, 1, 260, 182);
        this.appendInventory((IItemHandler)wrapper.getRailInventory(), 1, 15, 8, 32);
        this.appendInventory((IItemHandler)wrapper.getGroundInventory(), 2, 15, 8, 64);
        this.appendInventory((IItemHandler)wrapper.getTunnelInventory(), 3, 15, 8, 114);
        this.appendInventory((IItemHandler)wrapper.getRedstoneTorchInventory(), 1, 5, 8, 182);
        this.appendInventory((IItemHandler)wrapper.getTorchInventory(), 1, 4, 116, 182);
        this.appendPlayerInventory(playerInventory, 62, 214);
        this.addServerToClientTracker(BufferReferenceHolder.createIntHolder(wrapper::getFuel, wrapper::setFuel));
        this.addServerToClientTracker(BufferReferenceHolder.createByteHolder(() -> (byte)wrapper.getMode().ordinal(), value -> wrapper.setMode(((TrackBuilderMode[])TrackBuilderMode.class.getEnumConstants())[value])));
        this.changeModeMessage = (MessageHolder.EmptyMessageHolder)this.addClientToServerTracker((BufferReferenceHolder)new MessageHolder.EmptyMessageHolder(() -> {
            wrapper.setMode(TrackBuilderMode.cycle(wrapper.getMode()));
            wrapper.writeItemStack();
        }));
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.wrapper.writeItemStack();
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack remainingStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            remainingStack = stack.func_77946_l();
            if (index < 97 ? !this.func_75135_a(stack, 97, this.field_75151_b.size(), true) : (index >= 124 ? !this.func_75135_a(stack, 0, 124, false) : !this.func_75135_a(stack, 0, 97, false) && !this.func_75135_a(stack, 124, 133, false))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return remainingStack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.field_75224_c == player.field_71071_by && tmpSlot.getSlotIndex() == this.selectedSlot) {
            return tmpSlot.func_75211_c();
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.field_71071_by.func_70301_a(dragType);
            ItemStack itemStack = PlayerInventory.func_184435_e((int)this.selectedSlot) ? (ItemStack)player.field_71071_by.field_70462_a.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.field_71071_by.field_184439_c.get(0) : ItemStack.field_190927_a);
            if (!currentItem.func_190926_b() && stack == currentItem) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.wrapper instanceof TrackBuilderInventoryWrapper.Server) {
            ItemStack stack = ((TrackBuilderInventoryWrapper.Server)this.wrapper).getStack();
            return !stack.func_190926_b() && stack.func_77973_b() instanceof TrackBuilderItem;
        }
        return true;
    }

    public TrackBuilderInventoryWrapper getWrapper() {
        return this.wrapper;
    }

    public MessageHolder.EmptyMessageHolder getChangeModeMessage() {
        return this.changeModeMessage;
    }
}

