/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.UniversalGrid.apiiml.network.item;

import com.YTrollman.UniversalGrid.apiiml.network.grid.WirelessUniversalGridGridFactory;
import com.YTrollman.UniversalGrid.config.UniversalGridConfig;
import com.YTrollman.UniversalGrid.item.WirelessUniversalGridItem;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class WirelessUniversalGridNetworkItem
implements INetworkItem {
    private INetworkItemManager handler;
    private PlayerEntity player;
    private ItemStack stack;
    private PlayerSlot slot;

    public WirelessUniversalGridNetworkItem(INetworkItemManager handler, PlayerEntity player, ItemStack stack, PlayerSlot slot) {
        this.handler = handler;
        this.player = player;
        this.stack = stack;
        this.slot = slot;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public boolean onOpen(INetwork network) {
        IEnergyStorage energy = (IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (((Boolean)UniversalGridConfig.UNIVERSAL_GRID_USE_ENERGY.get()).booleanValue() && ((WirelessUniversalGridItem)this.stack.func_77973_b()).getType() != WirelessUniversalGridItem.Type.CREATIVE && energy != null && energy.getEnergyStored() <= (Integer)UniversalGridConfig.UNIVERSAL_GRID_OPEN_USAGE.get()) {
            this.sendOutOfEnergyMessage();
            return false;
        }
        if (!network.getSecurityManager().hasPermission(Permission.MODIFY, this.player)) {
            WorldUtils.sendNoPermissionMessage((PlayerEntity)this.player);
            return false;
        }
        API.instance().getGridManager().openGrid(WirelessUniversalGridGridFactory.ID, (ServerPlayerEntity)this.player, this.stack, this.slot);
        this.drainEnergy((Integer)UniversalGridConfig.UNIVERSAL_GRID_OPEN_USAGE.get());
        return true;
    }

    public void drainEnergy(int energy) {
        if (((Boolean)UniversalGridConfig.UNIVERSAL_GRID_USE_ENERGY.get()).booleanValue() && ((WirelessUniversalGridItem)this.stack.func_77973_b()).getType() != WirelessUniversalGridItem.Type.CREATIVE) {
            this.stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energy, false);
                if (energyStorage.getEnergyStored() <= 0) {
                    this.handler.close(this.player);
                    this.player.func_71053_j();
                    this.sendOutOfEnergyMessage();
                }
            });
        }
    }

    private void sendOutOfEnergyMessage() {
        this.player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_item.out_of_energy", new Object[]{new TranslationTextComponent(this.stack.func_77973_b().func_77658_a())}), this.player.func_110124_au());
    }
}

