/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.trollcave;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.trollcave.CloudCastleComponent;
import twilightforest.structures.trollcave.TrollCaveConnectComponent;
import twilightforest.structures.trollcave.TrollCavePieces;
import twilightforest.structures.trollcave.TrollVaultComponent;
import twilightforest.util.RotationUtil;
import twilightforest.world.feature.TFBiomeFeatures;
import twilightforest.world.feature.config.CaveStalactiteConfig;
import twilightforest.worldgen.BlockConstants;

public class TrollCaveMainComponent
extends TFStructureComponentOld {
    protected int size;
    protected int height;
    public static final ConfiguredFeature<?, ?> uberousGen = ((Feature)TFBiomeFeatures.MYCELIUM_BLOB.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(BlockConstants.UBEROUS_SOIL, FeatureSpread.func_242253_a((int)5, (int)6), 1, (List)ImmutableList.of((Object)BlockConstants.PODZOL, (Object)BlockConstants.COARSE_DIRT, (Object)BlockConstants.DIRT))).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(60, 10)));
    protected static final Predicate<Biome> highlands = biome -> false;

    public TrollCaveMainComponent(TemplateManager manager, CompoundNBT nbt) {
        this(TrollCavePieces.TFTCMai, nbt);
    }

    public TrollCaveMainComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.size = nbt.func_74762_e("size");
        this.height = nbt.func_74762_e("height");
    }

    public TrollCaveMainComponent(IStructurePieceType type, TFFeature feature, int index) {
        super(type, feature, index);
    }

    public TrollCaveMainComponent(IStructurePieceType type, TFFeature feature, int i, int x, int y, int z) {
        this(type, feature, i);
        this.func_186164_a(Direction.SOUTH);
        this.size = 30;
        this.height = 20;
        int radius = this.size / 2;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y += 10, z, -radius, -this.height, -radius, this.size, this.height, this.size, Direction.SOUTH);
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("size", this.size);
        tagCompound.func_74768_a("height", this.height);
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        for (Rotation caveRotation : RotationUtil.ROTATIONS) {
            BlockPos dest = this.getValidOpening(rand, caveRotation);
            this.makeSmallerCave(list, rand, this.func_74877_c() + 1, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p(), 18, 15, caveRotation);
        }
        CloudCastleComponent castle = new CloudCastleComponent(this.getFeatureType(), this.func_74877_c() + 1, this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2, 168, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2);
        list.add(castle);
        castle.func_74861_a(this, list, rand);
        TrollVaultComponent vault = new TrollVaultComponent(this.getFeatureType(), this.func_74877_c() + 1, this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2);
        list.add(vault);
        vault.func_74861_a(this, list, rand);
    }

    protected boolean makeSmallerCave(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int caveSize, int caveHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveConnectComponent cave = new TrollCaveConnectComponent(this.getFeatureType(), index, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p(), caveSize, caveHeight, direction);
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)cave.func_74874_b());
        if (intersect == null || intersect == this) {
            list.add(cave);
            cave.func_74861_a(list.get(0), list, rand);
            return true;
        }
        return false;
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos dest;
        int i;
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, generator, decoRNG, Blocks.field_150348_b, 0.7f, true, dest.func_177958_n(), 3, dest.func_177952_p(), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, generator, decoRNG, Blocks.field_150348_b, 0.5f, false, dest.func_177958_n(), 3, dest.func_177952_p(), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateAtSurface(world, generator, uberousGen, decoRNG, dest.func_177958_n(), 60, dest.func_177952_p(), sbb);
        }
        return true;
    }

    protected BlockPos getCoordsInCave(Random rand) {
        return new BlockPos(rand.nextInt(this.size - 1), rand.nextInt(this.height - 1), rand.nextInt(this.size - 1));
    }

    protected BlockPos getCenterBiasedCaveCoords(Random rand) {
        return new BlockPos(this.size - rand.nextInt(this.size / 2), rand.nextInt(this.height - 1), this.size - rand.nextInt(this.size / 2));
    }

    protected void hollowCaveMiddle(ISeedReader world, MutableBoundingBox boundingBox, Random rand, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int threshold = this.size / 5;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int ez;
                    int ey;
                    int ex = Math.min(x - minX, maxX - x);
                    double dist = Math.sqrt(ex * (ey = Math.min((y - minY) * 2, maxY - y)) * (ez = Math.min(z - minZ, maxZ - z)));
                    if (dist > (double)threshold) {
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, y, z, boundingBox);
                        continue;
                    }
                    if (dist != (double)threshold || rand.nextInt(4) != 0 || !this.func_175807_a((IBlockReader)world, x, y, z, boundingBox).func_177230_c().func_203417_a((ITag)BlockTags.field_242172_aH)) continue;
                    this.func_175811_a(world, ((Block)TFBlocks.trollsteinn.get()).func_176223_P(), x, y, z, boundingBox);
                }
            }
        }
    }

    public BlockPos getValidOpening(Random rand, Rotation direction) {
        int offset = this.size / 4;
        int wLength = this.size - offset * 2;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = rand.nextInt(offset) - rand.nextInt(offset);
            return new BlockPos(rx, ry, rz);
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = rand.nextInt(offset) - rand.nextInt(offset);
            return new BlockPos(rx, ry, rz);
        }
        return null;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int towerSize, Direction direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        if (direction == Direction.SOUTH) {
            return new BlockPos(dx - 1, dy - 1, dz - towerSize / 2);
        }
        if (direction == Direction.WEST) {
            return new BlockPos(dx + towerSize / 2, dy - 1, dz - 1);
        }
        if (direction == Direction.NORTH) {
            return new BlockPos(dx + 1, dy - 1, dz + towerSize / 2);
        }
        if (direction == Direction.EAST) {
            return new BlockPos(dx - towerSize / 2, dy - 1, dz + 1);
        }
        return new BlockPos(x, y, z);
    }

    protected void generateBlockStalactite(ISeedReader world, ChunkGenerator generator, Random rand, Block blockToGenerate, float length, boolean up, int x, int y, int z, MutableBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)pos)) {
            ((Feature)TFBiomeFeatures.CAVE_STALACTITE.get()).func_225566_b_((IFeatureConfig)new CaveStalactiteConfig(blockToGenerate.func_176223_P(), length, -1, -1, up)).func_242765_a(world, generator, rand, pos);
        }
    }

    protected void generateAtSurface(ISeedReader world, ChunkGenerator generator, ConfiguredFeature<?, ?> feature, Random rand, int x, int y, int z, MutableBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos.Mutable pos = new BlockPos.Mutable(dx, dy = y, dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)pos)) {
            for (dy = y; dy < y + 32; ++dy) {
                pos.func_185336_p(dy);
                if (world.func_175623_d((BlockPos)pos)) break;
            }
            feature.func_242765_a(world, generator, rand, pos.func_185334_h());
        }
    }

    protected void makeTreasureCrate(ISeedReader world, MutableBoundingBox sbb) {
        int mid = this.size / 2;
        this.func_175804_a(world, sbb, mid - 2, 0, mid - 2, mid + 1, 3, mid + 1, Blocks.field_150343_Z.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), false);
        this.func_74878_a(world, sbb, mid - 1, 1, mid - 1, mid, 2, mid);
        this.placeTreasureAtCurrentPosition(world, mid, 1, mid, TFTreasure.troll_garden, false, sbb);
    }
}

