/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastleBellTower21Component;
import twilightforest.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.structures.finalcastle.FinalCastleDamagedTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleEntranceTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.finalcastle.FinalCastleRoof13ConicalComponent;
import twilightforest.structures.finalcastle.FinalCastleRoof13CrenellatedComponent;
import twilightforest.structures.lichtower.TowerWingComponent;
import twilightforest.util.RotationUtil;

public class FinalCastleMazeTower13Component
extends TowerWingComponent {
    public static final int LOWEST_DOOR = 144;
    public static final int HIGHEST_DOOR = 222;
    public BlockState color;

    public FinalCastleMazeTower13Component(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.color = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("color"));
    }

    public FinalCastleMazeTower13Component(TemplateManager manager, CompoundNBT nbt) {
        this(FinalCastlePieces.TFFCSiTo, nbt);
    }

    public FinalCastleMazeTower13Component(IStructurePieceType piece, TFFeature feature, Random rand, int i, int x, int y, int z, BlockState color, Direction direction) {
        super(piece, feature, i);
        this.func_186164_a(direction);
        this.color = color;
        this.size = 13;
        int floors = rand.nextInt(3) + 2;
        this.height = floors * 8 + 1;
        int entranceFloor = rand.nextInt(floors);
        if (y - entranceFloor * 8 < 144) {
            entranceFloor = 0;
        }
        if (y + (floors - entranceFloor) * 8 > 222) {
            entranceFloor = floors - 1;
        }
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -6, -(entranceFloor * 8), -6, this.size - 1, this.height, this.size - 1, Direction.SOUTH);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, Rotation.CLOCKWISE_180);
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_218657_a("color", (INBT)NBTUtil.func_190009_a((BlockState)this.color));
    }

    public FinalCastleMazeTower13Component(IStructurePieceType piece, TFFeature feature, Random rand, int i, int x, int y, int z, int floors, int entranceFloor, BlockState color, Direction direction) {
        super(piece, feature, i);
        this.func_186164_a(direction);
        this.color = color;
        this.size = 13;
        this.height = floors * 8 + 1;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -6, -(entranceFloor * 8), -6, this.size - 1, this.height, this.size - 1, Direction.SOUTH);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, Rotation.CLOCKWISE_180);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component(FinalCastlePieces.TFFCToF13, this.getFeatureType(), rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        TFStructureComponentOld roof = rand.nextBoolean() ? new FinalCastleRoof13ConicalComponent(this.getFeatureType(), rand, 4, this) : new FinalCastleRoof13CrenellatedComponent(this.getFeatureType(), rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
    }

    public void buildTowards(StructurePiece parent, List<StructurePiece> list, Random rand, BlockPos dest) {
        this.func_74861_a(parent, list, rand);
        if (this.func_74877_c() < 20) {
            if (this.isWithinRange(dest.func_177958_n(), dest.func_177952_p(), this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, 30)) {
                int howFar = 20;
                if (!(this.buildEndTowerTowards(list, rand, dest, this.findBestDirectionTowards(dest), howFar) || this.buildEndTowerTowards(list, rand, dest, this.findSecondDirectionTowards(dest), howFar) || this.buildEndTowerTowards(list, rand, dest, this.findThirdDirectionTowards(dest), howFar))) {
                    TwilightForestMod.LOGGER.info("Could not build final tower");
                }
            } else {
                int howFar = 14 + rand.nextInt(24);
                Direction facing = this.findBestDirectionTowards(dest);
                if (!(facing != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findSecondDirectionTowards(dest)) != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findThirdDirectionTowards(dest)) != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || this.buildContinueTowerTowards(list, rand, dest, this.func_186165_e(), howFar))) {
                    TwilightForestMod.LOGGER.info("Could not build tower randomly");
                }
            }
        } else {
            TwilightForestMod.LOGGER.info("Built 15 towers without reaching destination");
        }
        this.buildNonCriticalTowers(parent, list, rand);
    }

    protected void buildNonCriticalTowers(StructurePiece parent, List<StructurePiece> list, Random rand) {
        Direction dir = RotationUtil.getRandomFacing(rand);
        Rotation relativeRotation = RotationUtil.getRelativeRotation(this.func_186165_e(), dir);
        if (this.openingTowards[relativeRotation.ordinal()] || this.buildDamagedTower(list, rand, dir) || !this.buildDamagedTower(list, rand, dir = RotationUtil.getRandomFacing(rand))) {
            // empty if block
        }
    }

    private Direction findBestDirectionTowards(BlockPos dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.func_177958_n();
        int dz = cz - dest.func_177952_p();
        Direction absoluteDir = Math.abs(dx) > Math.abs(dz) ? (dx >= 0 ? Direction.EAST : Direction.WEST) : (dz >= 0 ? Direction.SOUTH : Direction.NORTH);
        return absoluteDir;
    }

    private Direction findSecondDirectionTowards(BlockPos dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.func_177958_n();
        int dz = cz - dest.func_177952_p();
        Direction absoluteDir = Math.abs(dx) < Math.abs(dz) ? (dx >= 0 ? Direction.EAST : Direction.WEST) : (dz >= 0 ? Direction.SOUTH : Direction.NORTH);
        return absoluteDir;
    }

    private Direction findThirdDirectionTowards(BlockPos dest) {
        Direction[] cardinals;
        Direction first = this.findBestDirectionTowards(dest);
        Direction second = this.findSecondDirectionTowards(dest);
        for (Direction f : cardinals = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            if (f == first || f == second || f == Rotation.CLOCKWISE_180.func_185831_a(this.func_186165_e())) continue;
            return f;
        }
        return this.func_186165_e();
    }

    private boolean buildContinueTowerTowards(List<StructurePiece> list, Random rand, BlockPos dest, Direction facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        int adjustmentRange = 60;
        if (this.isWithinRange(dest.func_177958_n(), dest.func_177952_p(), this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, adjustmentRange)) {
            opening = new BlockPos(opening.func_177958_n(), this.adjustOpening(opening.func_177956_o(), dest), opening.func_177952_p());
        }
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        StructurePiece start = list.get(0);
        int centerX = start.func_74874_b().field_78897_a + 128 >> 8 << 8;
        int centerZ = start.func_74874_b().field_78896_c + 128 >> 8 << 8;
        if (this.isWithinRange(centerX, centerZ, tc.func_177958_n(), tc.func_177952_p(), 128)) {
            FinalCastleMazeTower13Component sTower = new FinalCastleMazeTower13Component(FinalCastlePieces.TFFCSiTo, this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), this.color, facing);
            MutableBoundingBox largerBB = new MutableBoundingBox(sTower.func_74874_b());
            largerBB.field_78897_a -= 6;
            largerBB.field_78896_c -= 6;
            largerBB.field_78893_d += 6;
            largerBB.field_78892_f += 6;
            largerBB.field_78895_b = 0;
            largerBB.field_78894_e = 255;
            StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)largerBB);
            if (intersect == null) {
                list.add(sTower);
                sTower.buildTowards(this, list, rand, dest);
                BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
                FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
                list.add(bridge);
                bridge.func_74861_a(this, list, rand);
                this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
                return true;
            }
            TwilightForestMod.LOGGER.info("tower blocked by {}", (Object)intersect);
            return false;
        }
        TwilightForestMod.LOGGER.info("tower out of range");
        return false;
    }

    protected boolean buildDamagedTower(List<StructurePiece> list, Random rand, Direction facing) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        int howFar = 14 + rand.nextInt(24);
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        FinalCastleMazeTower13Component eTower = this.makeNewDamagedTower(rand, facing, tc);
        MutableBoundingBox largerBB = new MutableBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
            return true;
        }
        return false;
    }

    protected FinalCastleMazeTower13Component makeNewDamagedTower(Random rand, Direction facing, BlockPos tc) {
        return new FinalCastleDamagedTowerComponent(FinalCastlePieces.TFFCDamT, this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing);
    }

    private int adjustOpening(int posY, BlockPos dest) {
        int openY = posY;
        int realOpeningY = this.func_74862_a(openY);
        if (realOpeningY - dest.func_177956_o() < 12) {
            openY = this.height - 9;
        } else if (dest.func_177956_o() - realOpeningY < 12) {
            openY = 0;
        }
        return openY;
    }

    private boolean buildEndTowerTowards(List<StructurePiece> list, Random rand, BlockPos dest, Direction facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        opening = new BlockPos(opening.func_177958_n(), this.adjustOpening(opening.func_177956_o(), dest), opening.func_177952_p());
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        FinalCastleMazeTower13Component eTower = this.color == ((Block)TFBlocks.castle_rune_brick_pink.get()).func_176223_P() ? new FinalCastleEntranceTowerComponent(this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing) : new FinalCastleBellTower21Component(this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing);
        MutableBoundingBox largerBB = new MutableBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
            return true;
        }
        return false;
    }

    private boolean isWithinRange(int centerX, int centerZ, int posX, int posZ, int range) {
        boolean inRange;
        boolean bl = inRange = Math.abs(centerX - posX) < range && Math.abs(centerZ - posZ) < range;
        if (!inRange) {
            // empty if block
        }
        return inRange;
    }

    public BlockPos getValidOpeningCC(Random rand, Direction facing) {
        Rotation relative = RotationUtil.getRelativeRotation(this.func_186165_e(), facing);
        int floors = this.height / 8;
        if (relative == Rotation.NONE || relative == Rotation.CLOCKWISE_180) {
            int rx = relative == Rotation.NONE ? 12 : 0;
            int rz = 6;
            int ry = rand.nextInt(floors) * 8;
            return new BlockPos(rx, ry, rz);
        }
        if (relative == Rotation.CLOCKWISE_90 || relative == Rotation.COUNTERCLOCKWISE_90) {
            int rx = 6;
            int rz = relative == Rotation.CLOCKWISE_90 ? 12 : 0;
            int ry = rand.nextInt(floors) * 8;
            return new BlockPos(rx, ry, rz);
        }
        return new BlockPos(0, 0, 0);
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int howFar, Direction direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case SOUTH: {
                dx += howFar;
                break;
            }
            case WEST: {
                dz += howFar;
                break;
            }
            case NORTH: {
                dx -= howFar;
                break;
            }
            case EAST: {
                dz -= howFar;
                break;
            }
        }
        return new BlockPos(dx, dy, dz);
    }

    @Override
    public boolean func_230383_a_(ISeedReader worldIn, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        Random decoRNG = new Random(worldIn.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.func_74882_a(worldIn, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.func_175808_b(worldIn, this.deco.blockState, x, -1, z, sbb);
            }
        }
        int numBranches = 2 + decoRNG.nextInt(4) + decoRNG.nextInt(3);
        for (int i = 0; i < numBranches; ++i) {
            this.makeGlyphBranches(worldIn, decoRNG, this.getGlyphColour(), sbb);
        }
        this.addFloors(worldIn, decoRNG, sbb);
        this.makeOpenings(worldIn, sbb);
        return true;
    }

    public BlockState getGlyphColour() {
        if (this.color == null) {
            TwilightForestMod.LOGGER.warn("Final Castle tower has null for glyph color, this is a bug.");
            return ((Block)TFBlocks.castle_rune_brick_blue.get()).func_176223_P();
        }
        return this.color;
    }

    private void addFloors(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int floors = this.highestOpening / 8 + 1;
        Rotation rotation = Rotation.CLOCKWISE_90;
        for (int i = 1; i < floors; ++i) {
            this.func_175804_a(world, sbb, 1, i * 8, 1, 11, i * 8, 11, this.deco.blockState, this.deco.blockState, false);
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            this.addStairsDown(world, sbb, rotation, i * 8);
        }
        if (this.hasAccessibleRoof()) {
            this.addStairsDown(world, sbb, RotationUtil.ROTATIONS[floors + 2 & 3], this.height - 1);
        }
    }

    protected boolean hasAccessibleRoof() {
        return this.height - this.highestOpening < 9;
    }

    private void addStairsDown(ISeedReader world, MutableBoundingBox sbb, Rotation rotation, int y) {
        int sz;
        int sy;
        int sx;
        int i;
        for (i = 0; i < 4; ++i) {
            sx = 8 - i;
            sy = y - i;
            sz = 9;
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, Direction.WEST, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, Direction.WEST, false), sx, sy, sz - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz - 1, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz - 1, sx, sy + 3, sz, rotation);
        }
        this.fillBlocksRotated(world, sbb, 3, y - 4, 8, 4, y - 4, 9, this.deco.blockState, rotation);
        for (i = 0; i < 4; ++i) {
            sx = 4;
            sy = y - i - 4;
            sz = 7 - i;
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, Direction.NORTH, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, FinalCastleMazeTower13Component.getStairState(this.deco.stairState, Direction.NORTH, false), sx - 1, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx - 1, sy - 1, sz, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz, sx - 1, sy + 3, sz, rotation);
        }
    }

    @Override
    protected void makeDoorOpening(ISeedReader world, int dx, int dy, int dz, MutableBoundingBox sbb) {
        BlockState doorState = this.doorColor();
        if (dx == 0 || dx == this.size - 1) {
            this.func_175804_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 4, dz + 2, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx, dy, dz - 1, dx, dy + 3, dz + 1, doorState, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_175804_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 4, dz, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 3, dz, doorState, AIR, false);
        }
    }

    public BlockState doorColor() {
        if (this.color == ((Block)TFBlocks.castle_rune_brick_pink.get()).getBlock().func_176223_P()) {
            return ((Block)TFBlocks.castle_door_pink.get()).func_176223_P();
        }
        if (this.color == ((Block)TFBlocks.castle_rune_brick_blue.get()).getBlock().func_176223_P()) {
            return ((Block)TFBlocks.castle_door_blue.get()).func_176223_P();
        }
        if (this.color == ((Block)TFBlocks.castle_rune_brick_yellow.get()).getBlock().func_176223_P()) {
            return ((Block)TFBlocks.castle_door_yellow.get()).func_176223_P();
        }
        if (this.color == ((Block)TFBlocks.castle_rune_brick_purple.get()).getBlock().func_176223_P()) {
            return ((Block)TFBlocks.castle_door_purple.get()).func_176223_P();
        }
        TwilightForestMod.LOGGER.warn("Couldn't add door to tower, rune color couldn't be read");
        return Blocks.field_150350_a.func_176223_P();
    }
}

