/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastleBellTower21Component;
import twilightforest.structures.finalcastle.FinalCastleBossGazeboComponent;
import twilightforest.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.structures.finalcastle.FinalCastleDungeonStepsComponent;
import twilightforest.structures.finalcastle.FinalCastleEntranceTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleFoundation48Component;
import twilightforest.structures.finalcastle.FinalCastleLargeTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.structures.finalcastle.FinalCastleMuralComponent;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.finalcastle.FinalCastleRoof48CrenellatedComponent;
import twilightforest.structures.finalcastle.FinalCastleStairTowerComponent;
import twilightforest.structures.finalcastle.StructureTFDecoratorCastle;
import twilightforest.util.RotationUtil;

public class FinalCastleMainComponent
extends TFStructureComponentOld {
    public FinalCastleMainComponent(TemplateManager manager, CompoundNBT nbt) {
        super(FinalCastlePieces.TFFCMain, nbt);
    }

    public FinalCastleMainComponent(TFFeature feature, Random rand, int i, int x, int y, int z) {
        super(FinalCastlePieces.TFFCMain, feature, i);
        this.func_186164_a(Direction.SOUTH);
        this.spawnListIndex = 1;
        x = x + 127 >> 8 << 8;
        z = z + 127 >> 8 << 8;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -24, 120, -24, 48, 40, 48, Direction.SOUTH);
        BlockPos cc = TFFeature.getNearestCenterXYZ(x >> 4, z >> 4);
        int cx = x >> 8 << 8;
        int cz = z >> 8 << 8;
        if (this.deco == null) {
            this.deco = new StructureTFDecoratorCastle();
        }
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        FinalCastleFoundation48Component foundation = new FinalCastleFoundation48Component(this.getFeatureType(), rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        FinalCastleRoof48CrenellatedComponent roof = new FinalCastleRoof48CrenellatedComponent(this.getFeatureType(), rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
        FinalCastleBossGazeboComponent gazebo = new FinalCastleBossGazeboComponent(this.getFeatureType(), rand, 5, this);
        list.add(gazebo);
        gazebo.func_74861_a(this, list, rand);
        FinalCastleStairTowerComponent tower0 = new FinalCastleStairTowerComponent(this.getFeatureType(), rand, 3, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c, Direction.NORTH);
        list.add(tower0);
        tower0.func_74861_a(this, list, rand);
        FinalCastleLargeTowerComponent tower1 = new FinalCastleLargeTowerComponent(this.getFeatureType(), rand, 3, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c, Direction.EAST);
        list.add(tower1);
        tower1.func_74861_a(this, list, rand);
        FinalCastleStairTowerComponent tower2 = new FinalCastleStairTowerComponent(this.getFeatureType(), rand, 3, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, Direction.WEST);
        list.add(tower2);
        tower2.func_74861_a(this, list, rand);
        FinalCastleStairTowerComponent tower3 = new FinalCastleStairTowerComponent(this.getFeatureType(), rand, 3, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, Direction.SOUTH);
        list.add(tower3);
        tower3.func_74861_a(this, list, rand);
        BlockPos dest = new BlockPos(this.field_74887_e.field_78897_a - 4, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c - 24);
        this.buildTowerMaze(list, rand, 48, 0, 24, 60, Direction.SOUTH, ((Block)TFBlocks.castle_rune_brick_pink.get()).func_176223_P(), dest);
        dest = new BlockPos(this.field_74887_e.field_78893_d + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 24);
        this.buildTowerMaze(list, rand, 0, 30, 24, 60, Direction.NORTH, ((Block)TFBlocks.castle_rune_brick_blue.get()).func_176223_P(), dest);
        FinalCastleDungeonStepsComponent steps0 = new FinalCastleDungeonStepsComponent(this.getFeatureType(), rand, 5, this.field_74887_e.field_78897_a + 18, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c + 18, Direction.SOUTH);
        list.add(steps0);
        steps0.func_74861_a(this, list, rand);
        FinalCastleDungeonStepsComponent steps1 = steps0.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        FinalCastleDungeonStepsComponent steps2 = steps1.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        FinalCastleDungeonStepsComponent steps3 = steps2.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        steps3.buildLevelUnder(parent, list, rand, 1);
        BlockPos mc = this.offsetTowerCCoords(48, 23, 25, 1, Direction.SOUTH);
        FinalCastleMuralComponent mural0 = new FinalCastleMuralComponent(this.getFeatureType(), rand, 7, mc.func_177958_n(), mc.func_177956_o(), mc.func_177952_p(), 35, 30, Direction.SOUTH);
        list.add(mural0);
        mural0.func_74861_a(this, list, rand);
        BlockPos mc1 = this.offsetTowerCCoords(48, 33, 24, -1, Direction.SOUTH);
        FinalCastleMuralComponent mural1 = new FinalCastleMuralComponent(this.getFeatureType(), rand, 7, mc1.func_177958_n(), mc1.func_177956_o(), mc.func_177952_p(), 19, 12, Direction.NORTH);
        list.add(mural1);
        mural1.func_74861_a(this, list, rand);
    }

    private void buildTowerMaze(List<StructurePiece> list, Random rand, int x, int y, int z, int howFar, Direction direction, BlockState type, BlockPos dest) {
        boolean complete = false;
        for (int iterations = 0; !complete && iterations < 15; ++iterations) {
            LinkedList<StructurePiece> before = new LinkedList<StructurePiece>(list);
            BlockPos tc = this.offsetTowerCCoords(x, y, z, howFar, direction);
            FinalCastleMazeTower13Component sTower = new FinalCastleMazeTower13Component(FinalCastlePieces.TFFCSiTo, this.getFeatureType(), rand, 3, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), type, direction);
            BlockPos bc = this.offsetTowerCCoords(x, y, z, 1, direction);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, direction);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            list.add(sTower);
            sTower.buildTowards(this, list, rand, dest);
            if (this.isMazeComplete(list, type)) {
                complete = true;
                continue;
            }
            TwilightForestMod.LOGGER.info("Tower maze color {} INCOMPLETE, retrying!", (Object)type);
            list.clear();
            list.addAll(before);
        }
    }

    private boolean isMazeComplete(List<StructurePiece> list, BlockState type) {
        if (list.size() > 60) {
            TwilightForestMod.LOGGER.warn("Maze of color {} is getting a bit excessive.", (Object)type);
        }
        for (StructurePiece structurecomponent : list) {
            MutableBoundingBox boundingBox = structurecomponent.func_74874_b();
            int x = boundingBox.field_78893_d - boundingBox.field_78897_a / 2 + boundingBox.field_78897_a;
            int y = boundingBox.field_78894_e - boundingBox.field_78895_b / 2 + boundingBox.field_78895_b;
            int z = boundingBox.field_78892_f - boundingBox.field_78896_c / 2 + boundingBox.field_78896_c;
            if (type == ((Block)TFBlocks.castle_rune_brick_pink.get()).func_176223_P() && structurecomponent instanceof FinalCastleEntranceTowerComponent) {
                return true;
            }
            if (type != ((Block)TFBlocks.castle_rune_brick_blue.get()).func_176223_P() || !(structurecomponent instanceof FinalCastleBellTower21Component)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int howFar, Direction direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case SOUTH: {
                dx += howFar;
                break;
            }
            case WEST: {
                dz += howFar;
                break;
            }
            case NORTH: {
                dx -= howFar;
                break;
            }
            case EAST: {
                dz -= howFar;
                break;
            }
        }
        return new BlockPos(dx, dy, dz);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.func_74882_a(world, sbb, 0, 0, 0, 48, 40, 48, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 13, 30, 1, 47, 30, 12, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 13, 31, 12, 36, 31, 12, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 13, 30, 36, 47, 30, 47, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 13, 31, 36, 36, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 1, 30, 1, 12, 30, 47, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 12, 31, 12, 12, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 38, 25, 13, 47, 25, 35, false, rand, this.deco.randomBlocks);
        for (int i = 0; i < 5; ++i) {
            int y = 30 - i;
            this.makeMezzTopStairs(world, sbb, y, 10 + i, Direction.SOUTH);
            this.makeMezzTopStairs(world, sbb, y, 38 - i, Direction.NORTH);
            y = 25 - i;
            int x = 37 - i;
            BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.WEST, false);
            this.func_175804_a(world, sbb, x, y, 14, x, y, 22, stairState, stairState, false);
            this.func_175804_a(world, sbb, x, y - 1, 14, x, y - 1, 22, this.deco.blockState, this.deco.blockState, false);
            this.func_175804_a(world, sbb, x, y, 26, x, y, 34, stairState, stairState, false);
            this.func_175804_a(world, sbb, x, y - 1, 26, x, y - 1, 34, this.deco.blockState, this.deco.blockState, false);
        }
        for (int x = 11; x < 47; x += 12) {
            for (int z = 11; z < 47; z += 12) {
                this.func_175804_a(world, sbb, x, 1, z, x + 2, 40, z + 2, this.deco.pillarState, this.deco.blockState, false);
                this.makePillarBase(world, sbb, x, z, 1, false);
                this.makePillarBase(world, sbb, x, z, 19, true);
                this.makePillarBase(world, sbb, x, z, 21, false);
                this.makePillarBase(world, sbb, x, z, 39, true);
            }
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            for (int z = 11; z < 47; z += 12) {
                if (z == 23 && (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180)) continue;
                this.fillBlocksRotated(world, sbb, 1, 1, z, 1, 40, z + 2, this.deco.pillarState, rotation);
                this.makeHalfPillarBase(world, sbb, rotation, 1, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 19, z, true);
                this.makeHalfPillarBase(world, sbb, rotation, 21, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 39, z, true);
            }
        }
        this.func_74882_a(world, sbb, 1, 20, 1, 47, 20, 47, false, rand, this.deco.randomBlocks);
        BlockState fieldBlock = ((Block)TFBlocks.force_field_pink.get()).func_176223_P();
        this.func_175804_a(world, sbb, 12, 1, 12, 24, 10, 12, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 1, 12, 12, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 24, 1, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 1, 24, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 10, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 17, 1, 12, 19, 4, 12, ((Block)TFBlocks.castle_door_pink.get()).func_176223_P(), AIR, false);
        this.func_175804_a(world, sbb, 17, 1, 24, 19, 4, 24, ((Block)TFBlocks.castle_door_pink.get()).func_176223_P(), AIR, false);
        this.makeSmallTowerStairs(world, sbb, Rotation.NONE);
        this.makeSmallTowerStairs(world, sbb, Rotation.CLOCKWISE_90);
        this.makeSmallTowerStairs(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.makeLargeTowerStairs(world, sbb, Rotation.CLOCKWISE_180);
        this.func_175804_a(world, sbb, 48, 1, 23, 48, 4, 25, ((Block)TFBlocks.castle_door_yellow.get()).func_176223_P(), AIR, false);
        this.func_175804_a(world, sbb, 0, 31, 23, 0, 34, 25, ((Block)TFBlocks.castle_door_purple.get()).func_176223_P(), AIR, false);
        return true;
    }

    private void makeSmallTowerStairs(ISeedReader world, MutableBoundingBox sbb, Rotation rotation) {
        for (int y = 1; y < 4; ++y) {
            int z = 40 + y;
            this.fillBlocksRotated(world, sbb, 1, 1, z, 4, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 2, y, z, 3, y, z, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, false), rotation);
        }
    }

    private void makeLargeTowerStairs(ISeedReader world, MutableBoundingBox sbb, Rotation rotation) {
        BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, false);
        for (int y = 1; y < 4; ++y) {
            int z = 38 + y;
            this.fillBlocksRotated(world, sbb, 2, 1, z, 6, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 3, y, z, 5, y, z, stairState, rotation);
        }
    }

    private void makeMezzTopStairs(ISeedReader world, MutableBoundingBox sbb, int y, int z, Direction stairMeta) {
        BlockState stairState = FinalCastleMainComponent.getStairState(this.deco.stairState, stairMeta, false);
        this.func_175804_a(world, sbb, 38, y, z, 46, y, z, stairState, stairState, false);
        this.func_175804_a(world, sbb, 38, y - 1, z, 46, y - 1, z, this.deco.blockState, this.deco.blockState, false);
        this.func_74878_a(world, sbb, 38, y + 1, z, 46, y + 3, z);
    }

    private void makeHalfPillarBase(ISeedReader world, MutableBoundingBox sbb, Rotation rotation, int y, int z, boolean isFlipped) {
        this.fillBlocksRotated(world, sbb, 2, y, z - 1, 2, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.EAST, isFlipped), rotation);
        this.setBlockStateRotated(world, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, isFlipped), 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.SOUTH, isFlipped), 1, y, z + 3, rotation, sbb);
    }

    private void makePillarBase(ISeedReader world, MutableBoundingBox sbb, int x, int z, int y, boolean isFlipped) {
        this.func_175804_a(world, sbb, x, y, z + 3, x + 3, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.SOUTH, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x - 1, y, z - 1, x + 2, y, z - 1, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.NORTH, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x + 3, y, z - 1, x + 3, y, z + 2, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.EAST, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x - 1, y, z, x - 1, y, z + 3, FinalCastleMainComponent.getStairState(this.deco.stairState, Direction.WEST, isFlipped), AIR, false);
    }
}

