/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.TFEntities;
import twilightforest.entity.projectile.TFThrowableEntity;
import twilightforest.util.TFDamageSources;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class IceSnowballEntity
extends TFThrowableEntity
implements IRendersAsItem {
    private static final int DAMAGE = 2;

    public IceSnowballEntity(EntityType<? extends IceSnowballEntity> type, World world) {
        super(type, world);
    }

    public IceSnowballEntity(World world, LivingEntity thrower) {
        super(TFEntities.ice_snowball, world, thrower);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.makeTrail();
    }

    protected float func_70185_h() {
        return 0.006f;
    }

    public void makeTrail() {
        for (int i = 0; i < 2; ++i) {
            double dx = this.func_226277_ct_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
            double dy = this.func_226278_cu_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
            double dz = this.func_226281_cx_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        super.func_70097_a(source, amount);
        this.die();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int j = 0; j < 8; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result instanceof EntityRayTraceResult) {
            Entity target = ((EntityRayTraceResult)result).func_216348_a();
            if (!this.field_70170_p.field_72995_K && target instanceof LivingEntity) {
                target.func_70097_a(TFDamageSources.SNOWBALL_FIGHT((Entity)this, (LivingEntity)this.func_234616_v_()), 2.0f);
                if (target instanceof PlayerEntity) {
                    for (ItemStack stack : target.func_184193_aE()) {
                        stack.func_222118_a(this.field_70146_Z.nextInt(1), (LivingEntity)((PlayerEntity)target), user -> user.func_213361_c(stack.getEquipmentSlot()));
                    }
                }
            }
        }
        this.die();
    }

    private void die() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)Items.field_151126_ay);
    }
}

