/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import twilightforest.entity.boss.KnightPhantomEntity;
import twilightforest.item.TFItems;

public class PhantomUpdateFormationAndMoveGoal
extends Goal {
    private static final float CIRCLE_SMALL_RADIUS = 2.5f;
    private static final float CIRCLE_LARGE_RADIUS = 8.5f;
    private final KnightPhantomEntity boss;

    public PhantomUpdateFormationAndMoveGoal(KnightPhantomEntity entity) {
        this.boss = entity;
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75246_d() {
        this.boss.field_70145_X = this.boss.getTicksProgress() % 20 != 0;
        this.boss.setTicksProgress(this.boss.getTicksProgress() + 1);
        if (this.boss.getTicksProgress() >= this.boss.getMaxTicksForFormation()) {
            this.switchToNextFormation();
        }
        Vector3d dest = this.getDestination();
        this.boss.func_70605_aq().func_75642_a(dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, this.boss.isChargingAtPlayer() ? 2.0 : 1.0);
    }

    public Vector3d getDestination() {
        if (!this.boss.hasHome()) {
            this.boss.func_213390_a(this.boss.func_233580_cy_(), 20);
        }
        switch (this.boss.getCurrentFormation()) {
            case LARGE_CLOCKWISE: {
                return this.getCirclePosition(8.5f, true);
            }
            case SMALL_CLOCKWISE: {
                return this.getCirclePosition(2.5f, true);
            }
            case LARGE_ANTICLOCKWISE: {
                return this.getCirclePosition(8.5f, false);
            }
            case SMALL_ANTICLOCKWISE: {
                return this.getCirclePosition(2.5f, false);
            }
            case CHARGE_PLUSX: {
                return this.getMoveAcrossPosition(true, true);
            }
            case CHARGE_MINUSX: {
                return this.getMoveAcrossPosition(false, true);
            }
            case CHARGE_PLUSZ: {
                return this.getMoveAcrossPosition(true, false);
            }
            case ATTACK_PLAYER_START: 
            case HOVER: {
                return this.getHoverPosition(8.5f);
            }
            case CHARGE_MINUSZ: {
                return this.getMoveAcrossPosition(false, false);
            }
            default: {
                return this.getLoiterPosition();
            }
            case ATTACK_PLAYER_ATTACK: 
        }
        return this.getAttackPlayerPosition();
    }

    private void switchToNextFormation() {
        List<KnightPhantomEntity> nearbyKnights = this.boss.getNearbyKnights();
        if (this.boss.getCurrentFormation() == KnightPhantomEntity.Formation.ATTACK_PLAYER_START) {
            this.boss.switchToFormation(KnightPhantomEntity.Formation.ATTACK_PLAYER_ATTACK);
        } else if (this.boss.getCurrentFormation() == KnightPhantomEntity.Formation.ATTACK_PLAYER_ATTACK) {
            if (nearbyKnights.size() > 1) {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.WAITING_FOR_LEADER);
            } else {
                switch (this.boss.func_70681_au().nextInt(3)) {
                    case 0: {
                        this.boss.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TFItems.knightmetal_sword.get()));
                        break;
                    }
                    case 1: {
                        this.boss.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TFItems.knightmetal_axe.get()));
                        break;
                    }
                    case 2: {
                        this.boss.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)TFItems.knightmetal_pickaxe.get()));
                    }
                }
                this.boss.switchToFormation(KnightPhantomEntity.Formation.ATTACK_PLAYER_START);
            }
        } else if (this.boss.getCurrentFormation() == KnightPhantomEntity.Formation.WAITING_FOR_LEADER) {
            if (nearbyKnights.size() > 1) {
                this.boss.switchToFormation(nearbyKnights.get(1).getCurrentFormation());
                this.boss.setTicksProgress(nearbyKnights.get(1).getTicksProgress());
            } else {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.ATTACK_PLAYER_START);
            }
        } else if (this.isThisTheLeader(nearbyKnights)) {
            this.pickRandomFormation();
            this.broadcastMyFormation(nearbyKnights);
            if (this.isNobodyCharging(nearbyKnights)) {
                this.makeARandomKnightCharge(nearbyKnights);
            }
        }
    }

    private boolean isThisTheLeader(List<KnightPhantomEntity> nearbyKnights) {
        boolean iAmTheLowest = true;
        for (KnightPhantomEntity knight : nearbyKnights) {
            if (knight.getNumber() >= this.boss.getNumber()) continue;
            iAmTheLowest = false;
            break;
        }
        return iAmTheLowest;
    }

    private void pickRandomFormation() {
        switch (this.boss.func_70681_au().nextInt(8)) {
            case 0: 
            case 7: {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.SMALL_CLOCKWISE);
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.CHARGE_PLUSX);
                break;
            }
            case 4: {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.CHARGE_MINUSX);
                break;
            }
            case 5: {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.CHARGE_PLUSZ);
                break;
            }
            case 6: {
                this.boss.switchToFormation(KnightPhantomEntity.Formation.CHARGE_MINUSZ);
            }
        }
    }

    private void makeARandomKnightCharge(List<KnightPhantomEntity> nearbyKnights) {
        int randomNum = this.boss.func_70681_au().nextInt(nearbyKnights.size());
        nearbyKnights.get(randomNum).switchToFormation(KnightPhantomEntity.Formation.ATTACK_PLAYER_START);
    }

    private void broadcastMyFormation(List<KnightPhantomEntity> nearbyKnights) {
        for (KnightPhantomEntity knight : nearbyKnights) {
            if (knight.isChargingAtPlayer()) continue;
            knight.switchToFormation(this.boss.getCurrentFormation());
        }
    }

    private boolean isNobodyCharging(List<KnightPhantomEntity> nearbyKnights) {
        boolean noCharge = true;
        for (KnightPhantomEntity knight : nearbyKnights) {
            if (!knight.isChargingAtPlayer()) continue;
            noCharge = false;
            break;
        }
        return noCharge;
    }

    private Vector3d getMoveAcrossPosition(boolean plus, boolean alongX) {
        float offset0 = (float)this.boss.getNumber() * 3.0f - 7.5f;
        float offset1 = this.boss.getTicksProgress() < 60 ? -7.0f : -7.0f + (float)(this.boss.getTicksProgress() - 60) / 120.0f * 14.0f;
        if (!plus) {
            offset1 *= -1.0f;
        }
        double dx = (float)this.boss.func_213384_dI().func_177958_n() + (alongX ? offset0 : offset1);
        double dy = (double)this.boss.func_213384_dI().func_177956_o() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = (float)this.boss.func_213384_dI().func_177952_p() + (alongX ? offset1 : offset0);
        return new Vector3d(dx, dy, dz);
    }

    private Vector3d getCirclePosition(float distance, boolean clockwise) {
        float angle = (float)this.boss.getTicksProgress() * 2.0f;
        if (!clockwise) {
            angle *= -1.0f;
        }
        double dx = (double)this.boss.func_213384_dI().func_177958_n() + Math.cos((double)(angle += 60.0f * (float)this.boss.getNumber()) * Math.PI / 180.0) * (double)distance;
        double dy = (double)this.boss.func_213384_dI().func_177956_o() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = (double)this.boss.func_213384_dI().func_177952_p() + Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vector3d(dx, dy, dz);
    }

    private Vector3d getHoverPosition(float distance) {
        double oz;
        double dx = this.boss.field_70142_S;
        double dy = (double)this.boss.func_213384_dI().func_177956_o() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = this.boss.field_70136_U;
        double ox = (double)this.boss.func_213384_dI().func_177958_n() - dx;
        double dDist = Math.sqrt(ox * ox + (oz = (double)this.boss.func_213384_dI().func_177952_p() - dz) * oz);
        if (dDist > (double)distance) {
            dx = (double)this.boss.func_213384_dI().func_177958_n() + ox / dDist * (double)distance;
            dz = (double)this.boss.func_213384_dI().func_177952_p() + oz / dDist * (double)distance;
        }
        return new Vector3d(dx, dy, dz);
    }

    private Vector3d getLoiterPosition() {
        double dx = this.boss.func_213384_dI().func_177958_n();
        double dy = (double)this.boss.func_213384_dI().func_177956_o() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = this.boss.func_213384_dI().func_177952_p();
        return new Vector3d(dx, dy, dz);
    }

    private Vector3d getAttackPlayerPosition() {
        if (this.boss.isSwordKnight()) {
            return Vector3d.func_237491_b_((Vector3i)this.boss.getChargePos());
        }
        return this.getHoverPosition(8.5f);
    }
}

