/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.util.TFDamageSources;

public class WraithEntity
extends FlyingEntity
implements IMob {
    public WraithEntity(EntityType<? extends WraithEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new NoClipMoveHelper((MobEntity)this);
        this.field_70145_X = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new AIAttack(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AIFlyTowardsTarget(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public boolean func_226271_bk_() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        int i = 0;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if (flag = entityIn.func_70097_a(TFDamageSources.HAUNT((LivingEntity)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213293_j(this.func_213322_ci().func_82615_a() * 0.6, this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c() * 0.6);
            }
            if ((j = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity entityplayer = (PlayerEntity)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof AxeItem && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    private void despawnIfPeaceful() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.despawnIfPeaceful();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            if (this.func_184187_bx() == entity || this.func_184188_bt().contains(entity)) {
                return true;
            }
            if (entity != this && entity instanceof LivingEntity && !source.func_180136_u()) {
                this.func_70624_b((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.WRAITH_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSounds.WRAITH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.WRAITH_DEATH;
    }

    public static boolean getCanSpawnHere(EntityType<? extends WraithEntity> entity, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random) && WraithEntity.func_223315_a(entity, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }

    public static class AILookAround
    extends Goal {
        private final WraithEntity parentEntity;

        public AILookAround(WraithEntity wraith) {
            this.parentEntity = wraith;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.func_213322_ci().func_82615_a(), (double)this.parentEntity.func_213322_ci().func_82616_c())) * 57.295776f;
            } else {
                LivingEntity entitylivingbase = this.parentEntity.func_70638_az();
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = entitylivingbase.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIRandomFly
    extends Goal {
        private final WraithEntity parentEntity;

        public AIRandomFly(WraithEntity wraith) {
            this.parentEntity = wraith;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            if (this.parentEntity.func_70638_az() != null) {
                return false;
            }
            MovementController entitymovehelper = this.parentEntity.func_70605_aq();
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.5);
        }
    }

    static class AIAttack
    extends Goal {
        private final WraithEntity taskOwner;
        private int attackTick = 20;

        AIAttack(WraithEntity taskOwner) {
            this.taskOwner = taskOwner;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.taskOwner.func_70638_az();
            return target != null && target.func_174813_aQ().field_72337_e > this.taskOwner.func_174813_aQ().field_72338_b && target.func_174813_aQ().field_72338_b < this.taskOwner.func_174813_aQ().field_72337_e && this.taskOwner.func_70068_e((Entity)target) <= 4.0;
        }

        public void func_75246_d() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
        }

        public void func_75251_c() {
            this.attackTick = 20;
        }

        public void func_75249_e() {
            if (this.taskOwner.func_70638_az() != null) {
                this.taskOwner.func_70652_k((Entity)this.taskOwner.func_70638_az());
            }
            this.attackTick = 20;
        }
    }

    static class AIFlyTowardsTarget
    extends Goal {
        private final WraithEntity taskOwner;

        AIFlyTowardsTarget(WraithEntity wraith) {
            this.taskOwner = wraith;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.taskOwner.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            LivingEntity target = this.taskOwner.func_70638_az();
            if (target != null) {
                this.taskOwner.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.5);
            }
        }
    }
}

