/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.loading.FMLEnvironment;
import twilightforest.item.MagicMapItem;

public class MapBiomesCommand {
    private static final DecimalFormat numberFormat = new DecimalFormat("#.00");
    private static final HashMap<Biome, Color> BIOME2COLOR = new HashMap();

    private static void init() {
        if (!BIOME2COLOR.isEmpty()) {
            return;
        }
    }

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"biomepng").requires(cs -> cs.func_197034_c(2))).executes(MapBiomesCommand::execute);
    }

    private static int execute(CommandContext<CommandSource> source) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return -1;
        }
        MapBiomesCommand.init();
        HashMap<Biome, Integer> biomeCount = new HashMap<Biome, Integer>();
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        int progressUpdate = img.getHeight() / 8;
        for (int x = 0; x < img.getHeight(); ++x) {
            for (int z = 0; z < img.getWidth(); ++z) {
                Biome b = ((CommandSource)source.getSource()).func_197023_e().func_225526_b_(x - 2048, 0, z - 2048);
                Color color = BIOME2COLOR.get(b);
                if (color == null) {
                    int colorInt = MagicMapItem.getBiomeColor(b);
                    if (colorInt == 0) {
                        colorInt = b.func_225528_a_(0.0, 0.0);
                    }
                    color = new Color(colorInt | 0xFF000000);
                    BIOME2COLOR.put(b, color);
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.setRGB(x, z, color.getRGB());
            }
            if (x % progressUpdate != 0) continue;
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent((double)x / (double)img.getHeight() * 100.0 + "% Done mapping"), true);
        }
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Approximate biome-block counts within an 2048x2048 region"), true);
        int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
        biomeCount.forEach((biome, integer) -> ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(biome.toString()).func_240702_b_(": " + integer + TextFormatting.GRAY + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), true));
        Path p = Paths.get("biomemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Image saved!"), true);
        return 1;
    }
}

